/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.FloydWarshallShortestPaths;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.GaussianDistributionRNG;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public class MRVMRegionsMap
implements Serializable {
    private static final long serialVersionUID = -7539511827334949347L;
    private final Graph<Region, DefaultEdge> adjacencyGraph;
    private transient FloydWarshallShortestPaths<Region, DefaultEdge> floyedWarshallDistances = null;

    public MRVMRegionsMap(MRVMWorldSetup worldStructure, RNGSupplier rngSupplier) {
        Graph<MRVMWorldSetup.RegionSetup, DefaultEdge> graphStructure = worldStructure.drawGraphStructure(rngSupplier.getUniformDistributionRNG());
        this.adjacencyGraph = this.makeGraph(graphStructure, rngSupplier.getGaussianDistributionRNG());
    }

    private Graph<Region, DefaultEdge> makeGraph(Graph<MRVMWorldSetup.RegionSetup, DefaultEdge> graphStructure, GaussianDistributionRNG rng) {
        SimpleGraph graph = new SimpleGraph(DefaultEdge.class);
        HashMap<MRVMWorldSetup.RegionSetup, Region> regions = new HashMap<MRVMWorldSetup.RegionSetup, Region>();
        int id_count = 0;
        for (MRVMWorldSetup.RegionSetup regInfo : graphStructure.vertexSet()) {
            Region reg = new Region(id_count++, regInfo, rng);
            regions.put(regInfo, reg);
            graph.addVertex((Object)reg);
        }
        for (DefaultEdge edge : graphStructure.edgeSet()) {
            Region source = (Region)regions.get(graphStructure.getEdgeSource((Object)edge));
            Region target = (Region)regions.get(graphStructure.getEdgeTarget((Object)edge));
            graph.addEdge((Object)source, (Object)target);
        }
        return graph;
    }

    private FloydWarshallShortestPaths<Region, DefaultEdge> getFloyedWarshallDistances() {
        if (this.floyedWarshallDistances == null) {
            this.floyedWarshallDistances = new FloydWarshallShortestPaths(this.adjacencyGraph);
        }
        return this.floyedWarshallDistances;
    }

    public int getLongestShortestPath(Region region) {
        Preconditions.checkArgument((boolean)this.adjacencyGraph.containsVertex((Object)region));
        ShortestPathAlgorithm.SingleSourcePaths shortestPaths = this.getFloyedWarshallDistances().getPaths((Object)region);
        int max = 0;
        for (Region vertex : this.adjacencyGraph.vertexSet()) {
            int length = shortestPaths.getPath((Object)vertex).getLength();
            if (length <= max) continue;
            max = length;
        }
        return max;
    }

    public Set<Region> adjacentRegions(Region region) {
        if (!this.adjacencyGraph.containsVertex((Object)region)) {
            throw new RuntimeException("Region not part of this map");
        }
        HashSet<Region> adjacentRegions = new HashSet<Region>();
        for (Region neighborCandidate : this.getRegions()) {
            if (!this.adjacencyGraph.containsEdge((Object)region, (Object)neighborCandidate)) continue;
            adjacentRegions.add(neighborCandidate);
        }
        return adjacentRegions;
    }

    public boolean areAdjacent(Region region, Region otherRegion) {
        return this.adjacencyGraph.containsEdge((Object)otherRegion, (Object)region) || this.adjacencyGraph.containsEdge((Object)region, (Object)otherRegion);
    }

    public int getDistance(Region regionOne, Region regionTwo) {
        if (regionOne.equals(regionTwo)) {
            return 0;
        }
        GraphPath shortestPath = this.getFloyedWarshallDistances().getPath((Object)regionOne, (Object)regionTwo);
        if (shortestPath == null) {
            return this.getNumberOfRegions() - 1;
        }
        List path = shortestPath.getEdgeList();
        if (path == null) {
            return this.getNumberOfRegions() - 1;
        }
        return path.size();
    }

    public Set<Region> getRegions() {
        return Collections.unmodifiableSet(this.adjacencyGraph.vertexSet());
    }

    public int getNumberOfRegions() {
        return this.adjacencyGraph.vertexSet().size();
    }

    public Region getRegion(int id) {
        for (Region region : this.getRegions()) {
            if (region.getId() != id) continue;
            return region;
        }
        throw new IllegalArgumentException("ID not known");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adjacencyGraph.vertexSet() == null ? 0 : this.adjacencyGraph.vertexSet().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MRVMRegionsMap other = (MRVMRegionsMap)obj;
        return !(this.adjacencyGraph == null ? other.adjacencyGraph != null : !this.adjacencyGraph.vertexSet().equals(other.adjacencyGraph.vertexSet()));
    }

    public static class Region
    implements Serializable {
        private static final long serialVersionUID = 6138501456844925185L;
        private final int id;
        private final int population;
        private final String note;

        private Region(int id, MRVMWorldSetup.RegionSetup setup, GaussianDistributionRNG rng) {
            this.id = id;
            this.population = setup.drawPopulation(rng);
            this.note = setup.getNotice();
        }

        public int getId() {
            return this.id;
        }

        public int getPopulation() {
            return this.population;
        }

        @Deprecated
        public String getNotice() {
            return this.getNote();
        }

        public String getNote() {
            return this.note;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append(String.valueOf(this.id));
            if (this.note != null && !this.note.equals("")) {
                builder.append(" (").append(this.note).append(")");
            }
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + (this.note == null ? 0 : this.note.hashCode());
            result = 31 * result + this.population;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Region other = (Region)obj;
            if (this.id != other.id) {
                return false;
            }
            if (this.note == null ? other.note != null : !this.note.equals(other.note)) {
                return false;
            }
            return this.population == other.population;
        }
    }
}

