/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import com.google.common.base.Preconditions;
import org.spectrumauctions.sats.core.model.License;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorld;

public final class SRVMLicense
extends License {
    private static final long serialVersionUID = 7672703280459172931L;
    private final String bandName;
    private transient SRVMBand band;

    SRVMLicense(long id, SRVMBand band) {
        super(id, band.getWorld().getId());
        this.band = band;
        this.bandName = band.getName();
    }

    public SRVMBand getBand() {
        return this.band;
    }

    @Override
    public SRVMWorld getWorld() {
        return this.band.getWorld();
    }

    void refreshFieldBackReferences(SRVMBand band) {
        Preconditions.checkArgument((boolean)band.getName().equals(this.bandName));
        this.band = band;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SRVMLicense)) {
            return false;
        }
        SRVMLicense other = (SRVMLicense)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$bandName = this.bandName;
        String other$bandName = other.bandName;
        return !(this$bandName == null ? other$bandName != null : !this$bandName.equals(other$bandName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SRVMLicense;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $bandName = this.bandName;
        result = result * 59 + ($bandName == null ? 43 : $bandName.hashCode());
        return result;
    }
}

