/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.spectrumauctions.sats.core.model.GenericWorld;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidder;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidderSetup;
import org.spectrumauctions.sats.core.model.srvm.SRVMLicense;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public final class SRVMWorld
extends World
implements GenericWorld {
    private static final long serialVersionUID = 1766287015715986936L;
    private final List<SRVMBand> bands;
    private transient Integer numberOfGoods = null;
    private transient List<SRVMLicense> licenses = null;

    public SRVMWorld(SRVMWorldSetup setup, RNGSupplier rngSupplier) {
        super("Single-Region Value Model");
        this.bands = Lists.newArrayList(SRVMBand.createBands(this, setup, rngSupplier));
        this.store();
    }

    @Override
    public int getNumberOfGoods() {
        if (this.numberOfGoods == null) {
            int count = 0;
            for (SRVMBand band : this.bands) {
                count += band.getLicenses().size();
            }
            this.numberOfGoods = count;
        }
        return this.numberOfGoods;
    }

    public ImmutableList<SRVMLicense> getLicenses() {
        if (this.licenses == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (SRVMBand band : this.bands) {
                builder.addAll(band.getLicenses());
            }
            this.licenses = builder.build();
        }
        return ImmutableList.copyOf(this.licenses);
    }

    public ImmutableList<SRVMBand> getBands() {
        return ImmutableList.copyOf(this.bands);
    }

    public ImmutableList<SRVMBidder> createPopulation(Collection<SRVMBidderSetup> bidderSetups, RNGSupplier rngSupplier) {
        long population = this.openNewPopulation();
        long currentId = 0L;
        ArrayList<SRVMBidder> bidders = new ArrayList<SRVMBidder>();
        for (SRVMBidderSetup setup : bidderSetups) {
            for (int i = 0; i < setup.getNumberOfBidders(); ++i) {
                bidders.add(new SRVMBidder(setup, this, currentId++, population, rngSupplier));
            }
        }
        return ImmutableList.copyOf(bidders);
    }

    public List<SRVMBidder> restorePopulation(long populationId) {
        return super.restorePopulation(SRVMBidder.class, populationId);
    }

    @Override
    public void refreshFieldBackReferences() {
        for (SRVMBand band : this.bands) {
            band.refreshFieldBackReferences(this);
        }
    }

    public List<SRVMBand> getAllGenericDefinitions() {
        return Collections.unmodifiableList(this.bands);
    }
}

