/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeIncreasing;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeOrdered;
import org.spectrumauctions.sats.core.model.GenericGood;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidder;

public class SizeOrderedGenericFactory {
    static BandComparator comparator = new BandComparator();

    public static GenericSizeOrdered getSizeOrderedGenericLang(boolean increasing, SRVMBidder bidder) throws UnsupportedBiddingLanguageException {
        ImmutableList<SRVMBand> bands = bidder.getWorld().getBands();
        if (increasing) {
            return new Increasing((List<SRVMBand>)bands, bidder);
        }
        return new Decreasing((Collection<SRVMBand>)bands, bidder);
    }

    private static class BandComparator
    implements Comparator<GenericGood>,
    Serializable {
        private static final long serialVersionUID = -7929466674087601381L;

        private BandComparator() {
        }

        @Override
        public int compare(GenericGood o1, GenericGood o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static final class Decreasing
    extends GenericSizeDecreasing {
        private final SRVMBidder bidder;

        protected Decreasing(Collection<SRVMBand> allPossibleGenericDefintions, SRVMBidder bidder) throws UnsupportedBiddingLanguageException {
            super(allPossibleGenericDefintions);
            this.bidder = bidder;
        }

        @Override
        public SRVMBidder getBidder() {
            return this.bidder;
        }

        @Override
        protected Comparator<GenericGood> getDefComparator() {
            return comparator;
        }
    }

    private static final class Increasing
    extends GenericSizeIncreasing {
        private final SRVMBidder bidder;

        protected Increasing(List<SRVMBand> allPossibleGenericDefintions, SRVMBidder bidder) throws UnsupportedBiddingLanguageException {
            super(allPossibleGenericDefintions);
            this.bidder = bidder;
        }

        @Override
        public SATSBidder getBidder() {
            return this.bidder;
        }

        @Override
        protected Comparator<GenericGood> getDefComparator() {
            return comparator;
        }
    }
}

