/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.util.instancehandling;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.util.CacheMap;
import org.spectrumauctions.sats.core.util.file.FileException;
import org.spectrumauctions.sats.core.util.file.FilePathUtils;
import org.spectrumauctions.sats.core.util.file.gson.GsonWrapper;
import org.spectrumauctions.sats.core.util.instancehandling.InstanceHandler;

public class JSONInstanceHandler
extends InstanceHandler {
    private FilePathUtils pathUtils = FilePathUtils.getInstance();
    private static JSONInstanceHandler instance;
    private final Map<Long, Long> populationIdCache = new CacheMap<Long, Long>(100);
    private long worldIdCache = 0L;

    private JSONInstanceHandler() {
    }

    public static JSONInstanceHandler getInstance() {
        if (instance == null) {
            instance = new JSONInstanceHandler();
        }
        return instance;
    }

    @Override
    public void writeWorld(World world) {
        File file = this.pathUtils.worldFilePath(world.getId());
        String json = new GsonWrapper().toJson(world);
        this.pathUtils.writeStringToFile(file, json);
    }

    @Override
    public void writeBidder(SATSBidder bidder) {
        File file = this.pathUtils.bidderFilePath(bidder.getWorld().getId(), bidder.getPopulation(), bidder.getLongId());
        String json = new GsonWrapper().toJson(bidder);
        this.pathUtils.writeStringToFile(file, json);
    }

    @Override
    public Collection<Long> getPopulationIds(long worldId) {
        return this.pathUtils.getPopulationIds(worldId);
    }

    @Override
    public <T extends SATSBidder> T readBidderWithUnknownType(Class<T> bidderSuperType, World world, long populationId, long bidderId) {
        File file = this.pathUtils.bidderFilePath(world.getId(), populationId, bidderId);
        String json = this.pathUtils.readFileToString(file);
        GsonWrapper gson = new GsonWrapper();
        gson.setWorld(world);
        Class<?> type = gson.readClass(json);
        Object obj = gson.fromJson(type, json);
        if (bidderSuperType.isAssignableFrom(obj.getClass())) {
            SATSBidder bidder = (SATSBidder)obj;
            bidder.refreshReference(world);
            return (T)bidder;
        }
        throw new FileException("generated object (" + type.getName() + ") is not of specified bidder type (" + bidderSuperType.getName() + ")");
    }

    @Override
    public <T extends SATSBidder> T readBidder(Class<T> type, World world, long populationId, long bidderId) {
        File file = this.pathUtils.bidderFilePath(world.getId(), populationId, bidderId);
        GsonWrapper gson = new GsonWrapper();
        gson.setWorld(world);
        String json = this.pathUtils.readFileToString(file);
        SATSBidder bidder = (SATSBidder)gson.fromJson(type, json);
        bidder.refreshReference(world);
        return (T)bidder;
    }

    @Override
    public <T extends SATSBidder> List<T> readPopulationWithUnknownTypes(Class<T> bidderSuperType, World world, long populationId) {
        ArrayList<T> bidders = new ArrayList<T>();
        Collection<Long> bidderIds = this.pathUtils.getBidderIds(world.getId(), populationId);
        for (long bidderId : bidderIds) {
            bidders.add(this.readBidderWithUnknownType(bidderSuperType, world, populationId, bidderId));
        }
        return bidders;
    }

    @Override
    public <T extends SATSBidder> Collection<T> readPopulation(Class<T> type, World world, long populationId) {
        HashSet<T> bidders = new HashSet<T>();
        Collection<Long> bidderIds = this.pathUtils.getBidderIds(world.getId(), populationId);
        for (long bidderId : bidderIds) {
            bidders.add(this.readBidder(type, world, populationId, bidderId));
        }
        return bidders;
    }

    @Override
    public long getNextWorldId() {
        long idCandidate = this.worldIdCache;
        idCandidate = this.recGetAndReserveNewWorldId(idCandidate);
        this.worldIdCache = idCandidate + 1L;
        return idCandidate;
    }

    private long recGetAndReserveNewWorldId(long idCandidate) {
        File potentialFolder = this.pathUtils.worldFolderPath(idCandidate);
        if (potentialFolder.mkdirs()) {
            return idCandidate;
        }
        return this.recGetAndReserveNewWorldId(idCandidate + 1L);
    }

    @Override
    public long getNextPopulationId(long worldId) {
        Long idCandidate = this.populationIdCache.remove(worldId);
        if (idCandidate == null) {
            idCandidate = Long.valueOf("0");
        }
        idCandidate = this.recOpenPopulation(worldId, 0L);
        Long newCacheId = idCandidate + 1L;
        this.populationIdCache.put(worldId, newCacheId);
        return idCandidate;
    }

    private long recOpenPopulation(long worldId, long idCandidate) {
        File potentialPopulationFolder = this.pathUtils.populationFolderPath(worldId, idCandidate);
        if (potentialPopulationFolder.mkdir()) {
            return idCandidate;
        }
        return this.recOpenPopulation(worldId, ++idCandidate);
    }

    @Override
    public <T extends World> T readWorld(Class<T> type, long worldId) {
        String json = this.pathUtils.readFileToString(this.pathUtils.worldFilePath(worldId));
        World world = (World)new GsonWrapper().fromJson(type, json);
        world.refreshFieldBackReferences();
        return (T)world;
    }
}

