/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.mechanism.mlca;

import java.math.BigDecimal;
import java.util.Map;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.SupportVectorSetup;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.kernels.Kernel;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.kernels.KernelDotProductExponential;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.kernels.KernelDotProductPolynomial;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.kernels.KernelGaussian;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.kernels.KernelLinear;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.kernels.KernelQuadratic;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.kernels.KernelType;

public enum SupportVectorSetupFactory {
    INSTANCE;

    private Map<KernelType, Kernel> gsvmDefaultKernels = Map.of(KernelType.Linear, new KernelLinear(0.0, 1.0), KernelType.Quadratic, new KernelQuadratic(0.0, 1.0, 0.0078125), KernelType.Polynomial, new KernelDotProductPolynomial(new double[]{0.0, 1.0, 0.0078125}), KernelType.Exponential, new KernelDotProductExponential(10.0, 10.0), KernelType.Gaussian, new KernelGaussian(20.0, 10.0));
    private Map<KernelType, SupportVectorSetup> gsvmTunedDefaultSetups = Map.of(KernelType.Linear, new SupportVectorSetup(1.0E8, 1.0E-5, BigDecimal.valueOf(100L), true, 1.0E-8, this.gsvmDefaultKernels.get(KernelType.Linear)), KernelType.Quadratic, new SupportVectorSetup(1000000.0, 1.0E-5, BigDecimal.valueOf(100L), true, 1.0E-8, this.gsvmDefaultKernels.get(KernelType.Quadratic)));
    private Map<KernelType, Kernel> lsvmDefaultKernels = Map.of(KernelType.Linear, new KernelLinear(0.0, 1.0), KernelType.Quadratic, new KernelQuadratic(0.0, 1.0, 0.03125), KernelType.Polynomial, new KernelDotProductPolynomial(new double[]{0.0, 1.0, 0.03125}), KernelType.Exponential, new KernelDotProductExponential(5.0, 10.0), KernelType.Gaussian, new KernelGaussian(10.0, 10.0));
    private Map<KernelType, SupportVectorSetup> lsvmTunedDefaultSetups = Map.of(KernelType.Linear, new SupportVectorSetup(1000000.0, 1.0E-5, BigDecimal.valueOf(100L), true, 1.0E-8, this.lsvmDefaultKernels.get(KernelType.Linear)), KernelType.Quadratic, new SupportVectorSetup(100000.0, 1.0E-5, BigDecimal.valueOf(100L), true, 1.0E-8, this.lsvmDefaultKernels.get(KernelType.Quadratic)));
    private Map<KernelType, Kernel> mrvmDefaultKernels = Map.of(KernelType.Linear, new KernelLinear(0.0, 1.0), KernelType.Quadratic, new KernelQuadratic(0.0, 1.0, 0.001), KernelType.Polynomial, new KernelDotProductPolynomial(new double[]{0.0, 1.0, 0.001}), KernelType.Exponential, new KernelDotProductExponential(100.0, 100.0), KernelType.Gaussian, new KernelGaussian(100.0, 100.0));

    public SupportVectorSetup createDefaultGSVMSupportVectorSetup(KernelType kernelType) {
        return this.gsvmTunedDefaultSetups.getOrDefault(kernelType, new SupportVectorSetup(1000000.0, 1.0E-5, BigDecimal.valueOf(100L), true, 1.0E-8, this.gsvmDefaultKernels.get(kernelType)));
    }

    public SupportVectorSetup createDefaultLSVMSupportVectorSetup(KernelType kernelType) {
        return this.lsvmTunedDefaultSetups.getOrDefault(kernelType, new SupportVectorSetup(100000.0, 1.0E-5, BigDecimal.valueOf(100L), true, 1.0E-8, this.lsvmDefaultKernels.get(kernelType)));
    }

    public SupportVectorSetup createDefaultMRVMSupportVectorSetup(KernelType kernelType) {
        return new SupportVectorSetup(1000.0, 1.0E-5, BigDecimal.ONE.divide(BigDecimal.valueOf(1000000L)), true, 1.0E-8, this.mrvmDefaultKernels.get(kernelType));
    }
}

