/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.gsvm;

import com.google.common.base.Preconditions;
import edu.harvard.econcs.jopt.solver.ISolution;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import org.marketdesignresearch.mechlib.core.Allocation;
import org.marketdesignresearch.mechlib.core.BidderAllocation;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.allocationlimits.AllocationLimitConstraint;
import org.marketdesignresearch.mechlib.core.bid.bundle.BundleExactValueBids;
import org.marketdesignresearch.mechlib.core.bid.bundle.BundleValueBids;
import org.marketdesignresearch.mechlib.core.bidder.Bidder;
import org.marketdesignresearch.mechlib.metainfo.MetaInfo;
import org.marketdesignresearch.mechlib.winnerdetermination.WinnerDetermination;
import org.spectrumauctions.sats.core.model.gsvm.GSVMBidder;
import org.spectrumauctions.sats.core.model.gsvm.GSVMLicense;
import org.spectrumauctions.sats.core.model.gsvm.GSVMWorld;
import org.spectrumauctions.sats.opt.model.ModelMIP;

public class GSVMStandardMIP
extends ModelMIP {
    private Map<GSVMBidder, Map<GSVMLicense, Map<Integer, Variable>>> gMap;
    private Map<GSVMBidder, Map<GSVMLicense, Double>> valueMap;
    private Map<GSVMBidder, Integer> tauHatMap;
    private Collection<Collection<Variable>> variableSetsOfInterest = new LinkedHashSet<Collection<Variable>>();
    private List<GSVMBidder> population;
    private GSVMWorld world;
    private boolean allowAssigningLicensesWithZeroBasevalue;

    public GSVMStandardMIP(List<GSVMBidder> population) {
        this(population.iterator().next().getWorld(), population);
    }

    public GSVMStandardMIP(GSVMWorld world, List<GSVMBidder> population) {
        this.allowAssigningLicensesWithZeroBasevalue = world.isLegacyGSVM();
        this.population = population;
        this.world = world;
        this.tauHatMap = new LinkedHashMap<GSVMBidder, Integer>();
        this.valueMap = new LinkedHashMap<GSVMBidder, Map<GSVMLicense, Double>>();
        this.getMIP().setObjectiveMax(true);
        this.initValues();
        this.initVariables();
        this.build();
    }

    @Override
    public ModelMIP getMIPWithout(Bidder bidder) {
        GSVMBidder gsvmBidder = (GSVMBidder)bidder;
        Preconditions.checkArgument((boolean)this.population.contains(gsvmBidder));
        return new GSVMStandardMIP(this.population.stream().filter(b -> !b.equals(gsvmBidder)).collect(Collectors.toList()));
    }

    public WinnerDetermination.PoolMode getSolutionPoolMode() {
        return WinnerDetermination.PoolMode.MODE_3;
    }

    @Override
    protected Allocation adaptMIPResult(ISolution solution) {
        LinkedHashMap<GSVMBidder, BidderAllocation> allocationMap = new LinkedHashMap<GSVMBidder, BidderAllocation>();
        for (GSVMBidder bidder : this.population) {
            LinkedHashSet<GSVMLicense> licenseSet = new LinkedHashSet<GSVMLicense>();
            for (GSVMLicense license : this.world.getLicenses()) {
                if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.valueMap.get(bidder).get(license) > 0.0)) continue;
                for (int tau = 0; tau < this.tauHatMap.get(bidder); ++tau) {
                    if (solution.getValue(this.gMap.get(bidder).get(license).get(tau)) != 1.0) continue;
                    licenseSet.add(license);
                }
            }
            Bundle bundle = Bundle.of(licenseSet);
            if (Bundle.EMPTY.equals((Object)bundle)) continue;
            allocationMap.put(bidder, new BidderAllocation(bidder.calculateValue(bundle), bundle, new LinkedHashSet()));
        }
        MetaInfo metaInfo = new MetaInfo();
        metaInfo.setNumberOfMIPs(1);
        metaInfo.setMipSolveTime(solution.getSolveTime());
        return new Allocation(allocationMap, (BundleValueBids)new BundleExactValueBids(), metaInfo);
    }

    public Map<Integer, Variable> getXVariables(GSVMBidder bidder, GSVMLicense license) {
        for (GSVMBidder b : this.population) {
            if (!b.equals(bidder)) continue;
            for (GSVMLicense l : this.world.getLicenses()) {
                if (!l.equals(license) || !this.gMap.get(b).containsKey(l)) continue;
                return this.gMap.get(b).get(l);
            }
        }
        return new LinkedHashMap<Integer, Variable>();
    }

    @Override
    public ModelMIP copyOf() {
        return new GSVMStandardMIP(this.population);
    }

    @Override
    protected Collection<Collection<Variable>> getVariablesOfInterest() {
        return this.variableSetsOfInterest;
    }

    private void build() {
        int tau;
        for (GSVMBidder bidder : this.population) {
            for (Object license : this.world.getLicenses()) {
                if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.valueMap.get(bidder).get(license) > 0.0)) continue;
                for (int tau2 = 0; tau2 < this.tauHatMap.get(bidder); ++tau2) {
                    this.getMIP().addObjectiveTerm(this.calculateComplementarityMarkup(tau2 + 1) * this.valueMap.get(bidder).get(license), this.gMap.get(bidder).get(license).get(tau2));
                }
            }
        }
        for (GSVMLicense license : this.world.getLicenses()) {
            Constraint constraint = new Constraint(CompareType.LEQ, 1.0, "SupplyConstraint license=" + license.getLongId());
            for (GSVMBidder bidder : this.population) {
                if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.valueMap.get(bidder).get(license) > 0.0)) continue;
                for (tau = 0; tau < this.tauHatMap.get(bidder); ++tau) {
                    constraint.addTerm(1.0, this.gMap.get(bidder).get(license).get(tau));
                }
            }
            this.getMIP().add(constraint);
        }
        for (GSVMLicense j : this.world.getLicenses()) {
            for (GSVMBidder bidder : this.population) {
                Constraint constraint = new Constraint(CompareType.GEQ, 0.0);
                for (GSVMLicense k : this.world.getLicenses()) {
                    if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.valueMap.get(bidder).get(k) > 0.0)) continue;
                    for (int tau3 = 0; tau3 < this.tauHatMap.get(bidder); ++tau3) {
                        constraint.addTerm(1.0, this.gMap.get(bidder).get(k).get(tau3));
                    }
                }
                for (tau = 0; tau < this.tauHatMap.get(bidder); ++tau) {
                    if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.valueMap.get(bidder).get(j) > 0.0)) continue;
                    constraint.addTerm((double)(-(tau + 1)), this.gMap.get(bidder).get(j).get(tau));
                }
                this.getMIP().add(constraint);
            }
        }
        for (GSVMBidder bidder : this.population) {
            Map bidderVariables = this.gMap.get(bidder).entrySet().stream().collect(Collectors.toMap(e -> (Good)e.getKey(), e -> new ArrayList(((Map)e.getValue()).values()), (e1, e2) -> e1, LinkedHashMap::new));
            for (AllocationLimitConstraint alc : bidder.getAllocationLimit().getConstraints()) {
                this.getMIP().add(alc.createCPLEXConstraintWithMultiVarsPerGood(bidderVariables));
            }
        }
    }

    private void initValues() {
        for (GSVMBidder bidder : this.population) {
            this.valueMap.put(bidder, new LinkedHashMap());
            int tauCounter = 0;
            for (GSVMLicense license : this.world.getLicenses()) {
                BigDecimal val = bidder.getBaseValues().getOrDefault(license.getLongId(), BigDecimal.ZERO);
                if (this.allowAssigningLicensesWithZeroBasevalue || val.doubleValue() > 0.0) {
                    ++tauCounter;
                }
                this.valueMap.get(bidder).put(license, val.doubleValue());
            }
            this.tauHatMap.put(bidder, tauCounter);
        }
    }

    private OptionalDouble getValue(int i, int j) {
        return this.population.stream().filter(bidder -> bidder.getLongId() == (long)i).mapToDouble(bidder -> {
            BigDecimal val = bidder.getBaseValues().get(j);
            return val == null ? 0.0 : val.doubleValue();
        }).reduce((element, otherElement) -> {
            throw new IllegalStateException("Error: Multiple values for agent: " + i + " and license: " + j + " in population");
        });
    }

    private void initVariables() {
        this.gMap = new LinkedHashMap<GSVMBidder, Map<GSVMLicense, Map<Integer, Variable>>>();
        for (GSVMBidder bidder : this.population) {
            this.gMap.put(bidder, new LinkedHashMap());
            for (GSVMLicense license : this.world.getLicenses()) {
                if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.valueMap.get(bidder).get(license) > 0.0)) continue;
                LinkedHashSet<Variable> xVariables = new LinkedHashSet<Variable>();
                this.gMap.get(bidder).put(license, new LinkedHashMap());
                for (int tau = 0; tau < this.tauHatMap.get(bidder); ++tau) {
                    Variable var = new Variable("g_i[" + (int)bidder.getLongId() + "]j[" + (int)license.getLongId() + "]t[" + tau + "]", VarType.BOOLEAN, 0.0, 1.0);
                    this.getMIP().add(var);
                    this.gMap.get(bidder).get(license).put(tau, var);
                    xVariables.add(var);
                }
                this.variableSetsOfInterest.add(xVariables);
            }
        }
    }

    private double calculateComplementarityMarkup(int tau) {
        if (tau < 1) {
            throw new IllegalArgumentException("Error: tau has to be >=1");
        }
        return 1.0 + (double)(tau - 1) * 0.2;
    }
}

