/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.avro.official;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.logging.Logger;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderAdapter;
import org.apache.avro.io.EncoderFactory;
import org.spf4j.avro.Adapter;
import org.spf4j.avro.SchemaResolver;

public final class OfficialAvroAdapter
implements Adapter {
    public static final JsonFactory FACTORY = new JsonFactory();
    private final EncoderFactory encFactory = EncoderFactory.get();
    private final DecoderFactory decFactory = DecoderFactory.get();

    public Encoder getJsonEncoder(Schema writerSchema, OutputStream os) throws IOException {
        return this.encFactory.jsonEncoder(writerSchema, os);
    }

    public Encoder getJsonEncoder(Schema writerSchema, Appendable os) throws IOException {
        return EncoderAdapter.jsonEncoder(writerSchema, FACTORY.createGenerator(CharStreams.asWriter((Appendable)os)));
    }

    public Schema.Field createField(String name, Schema schema, String doc, Object defaultVal, boolean validateDefault, boolean validateName, Schema.Field.Order order) {
        return new Schema.Field(name, schema, doc, defaultVal);
    }

    public Schema createRecordSchema(String name, String doc, String namespace, boolean isError, List<Schema.Field> fields, boolean validateName) {
        return Schema.createRecord((String)name, (String)doc, (String)namespace, (boolean)isError, fields);
    }

    public Schema createRecordSchema(String name, String doc, String namespace, boolean isError, boolean validateName) {
        return Schema.createRecord((String)name, (String)doc, (String)namespace, (boolean)isError);
    }

    public Decoder getJsonDecoder(Schema writerSchema, InputStream is) throws IOException {
        return this.decFactory.jsonDecoder(writerSchema, is);
    }

    public Schema parseSchema(Reader reader, boolean allowUndefinedLogicalTypes, SchemaResolver resolver) throws IOException {
        Logger.getLogger(OfficialAvroAdapter.class.getName()).warning("Official avro lib schema references not supported yet");
        return new Schema.Parser().parse(CharStreams.toString((Readable)reader));
    }

    public Schema parseSchema(Reader reader) throws IOException {
        return new Schema.Parser().parse(CharStreams.toString((Readable)reader));
    }

    public Decoder getJsonDecoder(Schema writerSchema, Reader reader) throws IOException {
        return this.decFactory.jsonDecoder(writerSchema, (InputStream)new ByteArrayInputStream(CharStreams.toString((Readable)reader).getBytes(StandardCharsets.UTF_8)));
    }

    public Decoder getJsonDecoder(Schema writerSchema, JsonParser parser) throws IOException {
        StringWriter buff = new StringWriter();
        TokenBuffer.asCopyOfValue((JsonParser)parser).serialize(FACTORY.createGenerator((Writer)buff));
        return this.decFactory.jsonDecoder(writerSchema, (InputStream)new ByteArrayInputStream(buff.toString().getBytes(StandardCharsets.UTF_8)));
    }

    public String toString() {
        return "OfficialAvroAdapter{encFactory=" + this.encFactory + ", decFactory=" + this.decFactory + '}';
    }

    public Decoder getYamlDecoder(Schema schema, Reader reader) {
        throw new UnsupportedOperationException();
    }

    public boolean isCompatible() {
        try {
            Schema.Field.class.getConstructor(String.class, Schema.class, String.class, Object.class, Boolean.TYPE, Boolean.TYPE, Schema.Field.Order.class);
            return false;
        }
        catch (NoSuchMethodException | SecurityException ex) {
            return true;
        }
    }

    static {
        FACTORY.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
    }
}

