/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.grizzly;

import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.spf4j.base.Env;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.Runtime;
import org.spf4j.base.SysExits;
import org.spf4j.base.ThreadLocalContextAttacher;
import org.spf4j.base.Throwables;
import org.spf4j.grizzly.JvmServices;
import org.spf4j.log.LogbackService;
import org.spf4j.os.OperatingSystem;
import org.spf4j.perf.ProcessVitals;
import org.spf4j.stackmonitor.FastStackCollector;
import org.spf4j.stackmonitor.ProfiledExecutionContextFactory;
import org.spf4j.stackmonitor.ProfilingTLAttacher;
import org.spf4j.stackmonitor.Sampler;
import org.spf4j.stackmonitor.TracingExecutionContexSampler;

public final class JvmServicesBuilder {
    private static volatile JvmServices services;
    private String hostName = null;
    private String applicationName = null;
    private String logFolder = null;
    private int profilerSampleTimeMillis = Env.getValue((String)"PROFILER_SAMPLE_MILLIS", (int)10);
    private int profilerDumpTimeMillis = Env.getValue((String)"PROFILER_DUMNP_MILLIS", (int)3600000);
    private boolean profilerJmx = Env.getValue((String)"PROFILER_JMX", (boolean)true);
    private int openFilesSampleTimeMillis = Env.getValue((String)"V_OPEN_FILES_S_MILLIS", (int)60000);
    private int memoryUseSampleTimeMillis = Env.getValue((String)"V_MEM_USE_S_MILLIS", (int)10000);
    private int gcUseSampleTimeMillis = Env.getValue((String)"V_GC_USE_S_MILLIS", (int)10000);
    private int threadUseSampleTimeMillis = Env.getValue((String)"V_THREAD_USE_S_MILLIS", (int)10000);
    private int cpuUseSampleTimeMillis = Env.getValue((String)"V_CPU_USE_S_MILLIS", (int)10000);
    private Function<ExecutionContext, String> aggregationGroups = ctx -> {
        String name = ctx.getName();
        if (name.startsWith("GET")) {
            return "GET";
        }
        if (ctx.getName().startsWith("POST")) {
            return "POST";
        }
        return "OTHER";
    };

    public JvmServicesBuilder withProfilingAggregationGroups(Function<ExecutionContext, String> contextAggregations) {
        this.aggregationGroups = contextAggregations;
        return this;
    }

    public JvmServicesBuilder withHostName(String phostName) {
        this.hostName = phostName;
        return this;
    }

    public JvmServicesBuilder withApplicationName(String papplicationName) {
        this.applicationName = papplicationName;
        return this;
    }

    public JvmServicesBuilder withLogFolder(String plogFolder) {
        this.logFolder = plogFolder;
        return this;
    }

    private void initUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionHandlerImpl());
    }

    private void initDefaults() {
        if (this.hostName == null) {
            this.hostName = Env.getValue((String)"KUBE_POD_NAME", () -> OperatingSystem.getHostName());
        }
        if (this.logFolder == null) {
            this.logFolder = Env.getValue((String)"LOG_FOLDER", (String)"/var/log");
        }
        if (this.applicationName == null) {
            this.applicationName = Env.getValue((String)"KUBE_APP_NAME", (String)"KUBE_APP_NAME");
        }
    }

    private void initMetricsStorage() {
        System.setProperty("spf4j.perf.ms.defaultTsdbFolderPath", this.logFolder);
    }

    private void initRequestAttributedProfiler() {
        System.setProperty("spf4j.execContext.tlAttacherClass", ProfilingTLAttacher.class.getName());
        System.setProperty("spf4j.execContext.factoryClass", ProfiledExecutionContextFactory.class.getName());
    }

    @Nullable
    private Sampler createSampler() {
        Sampler sampler;
        ThreadLocalContextAttacher threadLocalAttacher = ExecutionContexts.threadLocalAttacher();
        if (!(threadLocalAttacher instanceof ProfilingTLAttacher)) {
            Logger.getLogger(JvmServicesBuilder.class.getName()).log(Level.WARNING, "ProfilingTLAttacher is NOT active, alternate profiling config already set up: {}", threadLocalAttacher);
            sampler = new Sampler(this.profilerSampleTimeMillis, this.profilerDumpTimeMillis, t -> new FastStackCollector(false, true, new Thread[]{t}, new String[0]), this.logFolder, this.applicationName);
        } else {
            ProfilingTLAttacher contextFactory = (ProfilingTLAttacher)threadLocalAttacher;
            sampler = new Sampler(this.profilerSampleTimeMillis, this.profilerDumpTimeMillis, t -> new TracingExecutionContexSampler(() -> ((ProfilingTLAttacher)contextFactory).getCurrentThreadContexts(), this.aggregationGroups), this.logFolder, this.applicationName);
        }
        if (this.profilerJmx) {
            sampler.registerJmx();
        }
        return sampler;
    }

    public JvmServices build() {
        JvmServices svc = services;
        if (svc != null) {
            throw new IllegalStateException();
        }
        this.initDefaults();
        this.initMetricsStorage();
        this.initUncaughtExceptionHandler();
        this.initRequestAttributedProfiler();
        Sampler sampler = this.createSampler();
        services = svc = new JvmServicesImpl(sampler, new ProcessVitals(this.openFilesSampleTimeMillis, this.memoryUseSampleTimeMillis, this.gcUseSampleTimeMillis, this.threadUseSampleTimeMillis, this.cpuUseSampleTimeMillis), new LogbackService(this.applicationName, this.logFolder, this.hostName), this);
        return svc;
    }

    public String toString() {
        return "JvmServicesBuilder{hostName=" + this.hostName + ", applicationName=" + this.applicationName + ", logFolder=" + this.logFolder + ", profilerSampleTimeMillis=" + this.profilerSampleTimeMillis + ", profilerDumpTimeMillis=" + this.profilerDumpTimeMillis + ", profilerJmx=" + this.profilerJmx + ", openFilesSampleTimeMillis=" + this.openFilesSampleTimeMillis + ", memoryUseSampleTimeMillis=" + this.memoryUseSampleTimeMillis + ", gcUseSampleTimeMillis=" + this.gcUseSampleTimeMillis + ", threadUseSampleTimeMillis=" + this.threadUseSampleTimeMillis + ", cpuUseSampleTimeMillis=" + this.cpuUseSampleTimeMillis + '}';
    }

    private static class UncaughtExceptionHandlerImpl
    implements Thread.UncaughtExceptionHandler {
        private UncaughtExceptionHandlerImpl() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (Throwables.containsNonRecoverable((Throwable)e)) {
                Runtime.goDownWithError((Throwable)e, (SysExits)SysExits.EX_SOFTWARE);
            } else {
                Logger logger = Logger.getLogger("UNCAUGHT");
                logger.log(Level.SEVERE, "Error in thread {0}", t);
                logger.log(Level.SEVERE, "Exception detail", e);
            }
        }
    }

    private static class JvmServicesImpl
    implements JvmServices {
        private final Sampler sampler;
        private final ProcessVitals vitals;
        private final JvmServicesBuilder builder;
        private final LogbackService logService;

        JvmServicesImpl(Sampler sampler, ProcessVitals vitals, LogbackService logService, JvmServicesBuilder builder) {
            this.sampler = sampler;
            this.vitals = vitals;
            this.builder = builder;
            this.logService = logService;
        }

        @Override
        public String getLogFolder() {
            return this.builder.logFolder;
        }

        @Override
        public Sampler getProfiler() {
            return this.sampler;
        }

        @Override
        public String getApplicationName() {
            return this.builder.applicationName;
        }

        @Override
        public String getHostName() {
            return this.builder.hostName;
        }

        @Override
        public ProcessVitals getVitals() {
            return this.vitals;
        }

        @Override
        public LogbackService getLoggingService() {
            return this.logService;
        }
    }
}

