/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.grizzly;

import com.google.common.base.Joiner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Feature;
import org.apache.avro.SchemaResolver;
import org.apache.avro.SchemaResolvers;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.http.CompressionConfig;
import org.glassfish.grizzly.http.server.ErrorPageGenerator;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.servlet.FilterRegistration;
import org.glassfish.grizzly.servlet.FixedWebappContext;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.client.filter.EncodingFilter;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.spf4j.avro.NoSnapshotRefsResolver;
import org.spf4j.avro.SchemaClient;
import org.spf4j.base.Env;
import org.spf4j.base.TimeSource;
import org.spf4j.concurrent.LifoThreadPoolBuilder;
import org.spf4j.grizzly.GrizzlyErrorPageGenerator;
import org.spf4j.grizzly.JerseyService;
import org.spf4j.grizzly.JvmServices;
import org.spf4j.grizzly.Spf4jJaxrsApplication;
import org.spf4j.http.DeadlineProtocol;
import org.spf4j.http.DefaultDeadlineProtocol;
import org.spf4j.http.multi.MultiURLs;
import org.spf4j.http.multi.Spf4jURLStreamHandlerFactory;
import org.spf4j.jaxrs.JaxRsConfiguration;
import org.spf4j.jaxrs.Spf4jBinder;
import org.spf4j.jaxrs.client.Spf4JClient;
import org.spf4j.jaxrs.client.providers.ClientCustomExecutorServiceProvider;
import org.spf4j.jaxrs.client.providers.ClientCustomScheduledExecutionServiceProvider;
import org.spf4j.jaxrs.client.providers.ExecutionContextClientFilter;
import org.spf4j.jaxrs.common.providers.avro.DefaultSchemaProtocol;
import org.spf4j.jaxrs.common.providers.avro.SchemaProtocol;
import org.spf4j.jaxrs.config.MicroprofileConfigFeature;
import org.spf4j.jaxrs.features.AvroFeature;
import org.spf4j.jaxrs.features.GeneralPurposeFeatures;
import org.spf4j.jaxrs.server.DelegatingAuthenticationClientFilter;
import org.spf4j.jaxrs.server.SecurityAuthenticator;
import org.spf4j.jaxrs.server.features.ImmediateFeature;
import org.spf4j.jaxrs.server.providers.DefaultServerProvidersFeatures;
import org.spf4j.servlet.ExecutionContextFilter;
import org.spf4j.stackmonitor.Sampler;

public final class JerseyServiceBuilder
implements JaxRsConfiguration {
    private String bindAddr = "0.0.0.0";
    private int listenPort;
    private final Set<String> providerPackages;
    private final Set<Class<?>> serviceProviders;
    private final List<Binder> binders;
    private LinkedHashSet<String> mavenRepos;
    private final JvmServices jvmServices;
    private int kernelThreadsCoreSize;
    private int kernelThreadsMaxSize;
    private int workerThreadsCoreSize;
    private int workerThreadsMaxSize;
    private int maxHeaderSizeBytes;
    private long defaultTimeoutNanos;
    private long maximumAllowedTimeoutNanos;
    private SecurityAuthenticator auth = SecurityAuthenticator.NOAUTH;
    private SSLEngineConfigurator sslConfig;

    public JerseyServiceBuilder(JvmServices jvmServices) {
        this.listenPort = Env.getValue((String)"APP_SERVICE_PORT", (int)8080);
        this.providerPackages = new THashSet(5);
        this.serviceProviders = new THashSet(7);
        this.binders = new ArrayList<Binder>(4);
        this.jvmServices = jvmServices;
        this.mavenRepos = new LinkedHashSet(4);
        this.mavenRepos.add("https://repo1.maven.org/maven2");
        this.serviceProviders.add(GeneralPurposeFeatures.class);
        this.serviceProviders.add(DefaultServerProvidersFeatures.class);
        this.kernelThreadsCoreSize = 1;
        this.kernelThreadsMaxSize = 4;
        this.workerThreadsCoreSize = 4;
        this.workerThreadsMaxSize = 256;
        this.sslConfig = null;
        this.maxHeaderSizeBytes = 262144;
        this.defaultTimeoutNanos = TimeUnit.SECONDS.toNanos(10L);
        this.maximumAllowedTimeoutNanos = TimeUnit.SECONDS.toNanos(25L);
    }

    public JerseyServiceBuilder removeDefaults() {
        this.mavenRepos.clear();
        this.serviceProviders.clear();
        return this;
    }

    public JerseyServiceBuilder withBindAddress(String pbindAddr) {
        this.bindAddr = pbindAddr;
        return this;
    }

    public JerseyServiceBuilder withDefaultTimeout(long timeout, TimeUnit tu) {
        this.defaultTimeoutNanos = tu.toNanos(timeout);
        return this;
    }

    public JerseyServiceBuilder withMaximumAllowedTimeout(long timeout, TimeUnit tu) {
        this.maximumAllowedTimeoutNanos = tu.toNanos(timeout);
        return this;
    }

    public JerseyServiceBuilder withFeature(int pmaxHeaderSizeBytes) {
        this.maxHeaderSizeBytes = pmaxHeaderSizeBytes;
        return this;
    }

    public JerseyServiceBuilder withFeature(Class<? extends Feature> feature) {
        this.serviceProviders.add(feature);
        return this;
    }

    public JerseyServiceBuilder withServiceProvider(Class<?> serviceClass) {
        this.serviceProviders.add(serviceClass);
        return this;
    }

    public JerseyServiceBuilder withBinder(Binder binder) {
        this.binders.add(binder);
        return this;
    }

    public JerseyServiceBuilder withProviderPackage(String pkg) {
        this.providerPackages.add(pkg);
        return this;
    }

    public JerseyServiceBuilder withPort(int port) {
        this.listenPort = port;
        return this;
    }

    public JerseyServiceBuilder withKernelThreadsCoreSize(int size) {
        this.kernelThreadsCoreSize = size;
        return this;
    }

    public JerseyServiceBuilder withKernelThreadsMaxSize(int size) {
        this.kernelThreadsMaxSize = size;
        return this;
    }

    public JerseyServiceBuilder withWorkerThreadsMaxSize(int size) {
        this.workerThreadsMaxSize = size;
        return this;
    }

    public JerseyServiceBuilder withWorkerThreadsCoreSize(int size) {
        this.workerThreadsCoreSize = size;
        return this;
    }

    public JerseyServiceBuilder withSSLEngineConfigurator(SSLEngineConfigurator configurator) {
        this.sslConfig = configurator;
        return this;
    }

    public JerseyServiceBuilder withMavenRepoURL(String mavenRepoUrl) {
        LinkedHashSet<String> nRepos = new LinkedHashSet<String>((int)((double)(this.mavenRepos.size() + 1) * 1.4));
        nRepos.addAll(this.mavenRepos);
        nRepos.add(mavenRepoUrl);
        this.mavenRepos = nRepos;
        return this;
    }

    public JerseyServiceBuilder withSecurityAuthenticator(SecurityAuthenticator pauth) {
        this.auth = pauth;
        return this;
    }

    public Set<String> getProviderPackages() {
        return Collections.unmodifiableSet(this.providerPackages);
    }

    public List<Binder> getBinders() {
        return Collections.unmodifiableList(this.binders);
    }

    public JerseyService build() throws IOException {
        return new JerseyServiceImpl();
    }

    public String toString() {
        return "JerseyServiceBuilder{bindAddr=" + this.bindAddr + ", listenPort=" + this.listenPort + ", providerPackages=" + this.providerPackages + ", serviceProviders=" + this.serviceProviders + ", binders=" + this.binders + ", mavenRepos=" + this.mavenRepos + ", jvmServices=" + this.jvmServices + ", kernelThreadsCoreSize=" + this.kernelThreadsCoreSize + ", kernelThreadsMaxSize=" + this.kernelThreadsMaxSize + ", workerThreadsCoreSize=" + this.workerThreadsCoreSize + ", workerThreadsMaxSize=" + this.workerThreadsMaxSize + ", sslConfig=" + this.sslConfig + '}';
    }

    public Set<Class<? extends Feature>> getFeatures() {
        THashSet res = new THashSet(this.serviceProviders.size());
        for (Class<?> clasz : this.serviceProviders) {
            if (!Feature.class.isAssignableFrom(clasz)) continue;
            res.add(clasz);
        }
        return res;
    }

    private class JerseyServiceImpl
    implements JerseyService {
        private HttpServer server;
        private WebappContext appContext;
        private ResourceConfig resourceConfig;

        JerseyServiceImpl() throws IOException {
            this.createHttpServer();
        }

        private void createHttpServer() throws IOException {
            NoSnapshotRefsResolver schemaClient;
            DefaultDeadlineProtocol dp;
            FixedWebappContext webappContext;
            String jerseyAppName;
            block5: {
                jerseyAppName = JerseyServiceBuilder.this.bindAddr + ':' + JerseyServiceBuilder.this.listenPort;
                webappContext = new FixedWebappContext(jerseyAppName, "");
                dp = new DefaultDeadlineProtocol(JerseyServiceBuilder.this.defaultTimeoutNanos, JerseyServiceBuilder.this.maximumAllowedTimeoutNanos, TimeUnit.NANOSECONDS);
                FilterRegistration fr = webappContext.addFilter("ecFilter", (Filter)new ExecutionContextFilter((DeadlineProtocol)dp, JerseyServiceBuilder.this.auth));
                fr.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
                try {
                    block6: {
                        if (JerseyServiceBuilder.this.mavenRepos.size() == 1) {
                            schemaClient = new NoSnapshotRefsResolver((SchemaResolver)new SchemaClient(new URI((String)JerseyServiceBuilder.this.mavenRepos.iterator().next())));
                            break block5;
                        }
                        try {
                            URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new Spf4jURLStreamHandlerFactory());
                        }
                        catch (Error e) {
                            String msg = e.getMessage();
                            if (msg != null && msg.contains("factory already defined")) break block6;
                            throw e;
                        }
                    }
                    schemaClient = new NoSnapshotRefsResolver((SchemaResolver)new SchemaClient(MultiURLs.newURL((MultiURLs.Protocol)MultiURLs.Protocol.mhttps, (String[])JerseyServiceBuilder.this.mavenRepos.toArray(new String[JerseyServiceBuilder.this.mavenRepos.size()])).toURI()));
                }
                catch (URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
            }
            SchemaResolvers.registerDefault((SchemaResolver)schemaClient);
            String hostName = JerseyServiceBuilder.this.jvmServices.getHostName();
            this.resourceConfig = ResourceConfig.forApplicationClass(Spf4jJaxrsApplication.class);
            this.resourceConfig.setApplicationName(jerseyAppName);
            new MicroprofileConfigFeature().configure(this.resourceConfig);
            this.resourceConfig.register((Object)new MicroprofileConfigFeature());
            this.resourceConfig.registerInstances(JerseyServiceBuilder.this.binders.toArray(new Object[JerseyServiceBuilder.this.binders.size()]));
            this.resourceConfig.registerClasses(JerseyServiceBuilder.this.serviceProviders);
            this.resourceConfig.property(JaxRsConfiguration.class.getName(), (Object)JerseyServiceBuilder.this);
            this.resourceConfig.property("hostName", (Object)hostName);
            this.resourceConfig.property("servlet.bindAddr", (Object)JerseyServiceBuilder.this.bindAddr);
            this.resourceConfig.property("servlet.port", (Object)JerseyServiceBuilder.this.listenPort);
            this.resourceConfig.property("servlet.protocol", (Object)(JerseyServiceBuilder.this.sslConfig == null ? "http" : "https"));
            this.resourceConfig.property("application.logFilesPath", (Object)JerseyServiceBuilder.this.jvmServices.getLogFolder());
            this.resourceConfig.property("jersey.config.server.provider.packages", (Object)Joiner.on((char)';').join((Iterable)JerseyServiceBuilder.this.providerPackages));
            this.resourceConfig.property("jersey.config.server.wadl.disableWadl", (Object)"true");
            this.resourceConfig.register((Object)new AbstractBinder(){

                protected void configure() {
                    this.bind(JerseyServiceBuilder.this.jvmServices.getProfiler()).to(Sampler.class);
                }
            });
            AvroFeature avroFeature = new AvroFeature((SchemaProtocol)new DefaultSchemaProtocol((SchemaResolver)schemaClient), (SchemaResolver)schemaClient);
            Spf4JClient restClient = Spf4JClient.create((Client)((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().connectTimeout(2L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).register((Object)new ExecutionContextClientFilter((DeadlineProtocol)dp, true))).register(ClientCustomExecutorServiceProvider.class)).register(ClientCustomScheduledExecutionServiceProvider.class)).register((Object)new GeneralPurposeFeatures())).register(EncodingFilter.class)).register((Object)avroFeature)).register(DelegatingAuthenticationClientFilter.class)).property("jersey.config.client.useEncoding", (Object)"gzip")).build());
            this.resourceConfig.register((Object)new Spf4jBinder((SchemaResolver)schemaClient, restClient));
            this.resourceConfig.register((Object)avroFeature);
            this.resourceConfig.register(ImmediateFeature.class);
            ServletContainer servletContainer = new ServletContainer(this.resourceConfig);
            this.resourceConfig.property(ServletContainer.class.getName(), (Object)servletContainer);
            ServletRegistration servletRegistration = webappContext.addServlet("jersey", (Servlet)servletContainer);
            servletRegistration.addMapping(new String[]{"/*"});
            servletRegistration.setLoadOnStartup(0);
            HttpServer result = new HttpServer();
            ServerConfiguration serverConfig = result.getServerConfiguration();
            serverConfig.setDefaultErrorPageGenerator((ErrorPageGenerator)new GrizzlyErrorPageGenerator((SchemaResolver)schemaClient));
            result.addListener(this.createHttpListener(JerseyServiceBuilder.this.bindAddr, JerseyServiceBuilder.this.listenPort));
            webappContext.deploy(result);
            webappContext.setServerInfo(null);
            this.appContext = webappContext;
            this.server = result;
        }

        private NetworkListener createHttpListener(String pbindAddr, int port) {
            if (JerseyServiceBuilder.this.sslConfig == null) {
                return this.createHttpListener("http", pbindAddr, port);
            }
            NetworkListener nl = this.createHttpListener("https", pbindAddr, port);
            nl.setSecure(true);
            nl.setSSLEngineConfig(JerseyServiceBuilder.this.sslConfig);
            return nl;
        }

        private NetworkListener createHttpListener(String name, String pbindAddr, int port) {
            String poolNameBase = name + ':' + port;
            NetworkListener listener = new NetworkListener("http", pbindAddr, port);
            listener.setMaxHttpHeaderSize(JerseyServiceBuilder.this.maxHeaderSizeBytes);
            CompressionConfig compressionConfig = listener.getCompressionConfig();
            compressionConfig.setCompressionMode(CompressionConfig.CompressionMode.ON);
            compressionConfig.setCompressionMinSize(4096);
            compressionConfig.setCompressibleMimeTypes(new String[]{"text/plain", "text/html", "text/csv", "application/json", "application/octet-stream", "application/avro", "application/avro+json", "application/avro-x+json"});
            TCPNIOTransport transport = listener.getTransport();
            transport.setKernelThreadPool((ExecutorService)LifoThreadPoolBuilder.newBuilder().withCoreSize(JerseyServiceBuilder.this.kernelThreadsCoreSize).withMaxSize(JerseyServiceBuilder.this.kernelThreadsMaxSize).withDaemonThreads(true).withMaxIdleTimeMillis(Integer.getInteger("spf4j.grizzly.kernel.idleMillis", 120000).intValue()).withPoolName(poolNameBase + "-kernel").withQueueSizeLimit(64).enableJmx().build());
            transport.setSelectorRunnersCount(Integer.getInteger("spf4j.grizzly.selectorCount", 4).intValue());
            transport.setWorkerThreadPool((ExecutorService)LifoThreadPoolBuilder.newBuilder().withCoreSize(JerseyServiceBuilder.this.workerThreadsCoreSize).withMaxSize(JerseyServiceBuilder.this.workerThreadsMaxSize).withDaemonThreads(false).withMaxIdleTimeMillis(Integer.getInteger("spf4j.grizzly.worker.idleMillis", 120000).intValue()).withPoolName(poolNameBase + "-worker").withQueueSizeLimit(0).enableJmx().build());
            return listener;
        }

        @Override
        public void close() {
            Logger.getLogger("JerseyService").log(Level.INFO, "Shutting dow jersery service: {0}", this.server);
            this.appContext.undeploy();
            ArrayList<ExecutorService> tps = new ArrayList<ExecutorService>(4);
            for (NetworkListener listener : this.server.getListeners()) {
                TCPNIOTransport transport = listener.getTransport();
                tps.add(transport.getKernelThreadPool());
                tps.add(transport.getWorkerThreadPool());
            }
            GrizzlyFuture sf = this.server.shutdown(30L, TimeUnit.SECONDS);
            long deadlineNanos = TimeSource.nanoTime() + TimeUnit.NANOSECONDS.convert(30L, TimeUnit.SECONDS);
            for (ExecutorService es : tps) {
                es.shutdown();
            }
            Exception e = null;
            try {
                sf.get(TimeSource.getTimeToDeadlineStrict((long)deadlineNanos, (TimeUnit)TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
            }
            catch (TimeoutException ex) {
                e = ex;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (RuntimeException | ExecutionException ex) {
                e = ex;
            }
            for (ExecutorService es : tps) {
                try {
                    es.awaitTermination(TimeSource.getTimeToDeadlineStrict((long)deadlineNanos, (TimeUnit)TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
                }
                catch (TimeoutException ex) {
                    e = ex;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            this.server.shutdownNow();
            for (ExecutorService es : tps) {
                List<Runnable> remaining = es.shutdownNow();
                if (remaining.size() <= 0) continue;
                Logger.getLogger(JerseyServiceBuilder.class.getName()).log(Level.WARNING, "Remaining tasks: {0}", remaining);
            }
            if (e != null) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void start() throws IOException {
            this.server.start();
        }

        @Override
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"})
        public Spf4jJaxrsApplication getApplication() {
            return (Spf4jJaxrsApplication)this.resourceConfig.getApplication();
        }
    }
}

