/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.grizzly;

import org.spf4j.base.ShutdownHooks;
import org.spf4j.base.ShutdownThread;
import org.spf4j.log.LogbackService;
import org.spf4j.perf.ProcessVitals;
import org.spf4j.stackmonitor.Sampler;

public interface JvmServices
extends AutoCloseable {
    public String getApplicationName();

    public String getHostName();

    public String getLogFolder();

    public Sampler getProfiler();

    public ProcessVitals getVitals();

    public LogbackService getLoggingService();

    @Override
    default public void close() {
        try {
            this.getProfiler().stop();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        finally {
            try {
                this.getVitals().close();
            }
            finally {
                this.getLoggingService().stop();
            }
        }
    }

    default public JvmServices start() {
        this.getLoggingService().start();
        this.getVitals().start();
        this.getProfiler().start();
        return this;
    }

    default public JvmServices closeOnShutdown() {
        if (!ShutdownThread.get().queueHook(ShutdownHooks.ShutdownPhase.OBSERVABILITY_SERVICES, () -> {
            try {
                this.close();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        })) {
            this.close();
        }
        return this;
    }
}

