/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.grizzly;

import com.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.spf4j.cluster.Cluster;
import org.spf4j.cluster.Service;
import org.spf4j.cluster.SingleNodeCluster;
import org.spf4j.service.avro.NetworkProtocol;
import org.spf4j.service.avro.NetworkService;

public final class SingleNodeClusterFeature
implements Feature {
    public boolean configure(FeatureContext fc) {
        Configuration cfg = fc.getConfiguration();
        String bindAddr = (String)cfg.getProperty("servlet.bindAddr");
        int port = (Integer)cfg.getProperty("servlet.port");
        try {
            SingleNodeCluster singleNodeCluster = new SingleNodeCluster((Set)ImmutableSet.copyOf((Object[])InetAddress.getAllByName(bindAddr)), Collections.singleton(new NetworkService("http", port, NetworkProtocol.TCP)));
            fc.register((Object)new BindCluster((Cluster)singleNodeCluster));
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    private static class BindCluster
    extends AbstractBinder {
        private final Cluster singleNodeCluster;

        BindCluster(Cluster singleNodeCluster) {
            this.singleNodeCluster = singleNodeCluster;
        }

        protected void configure() {
            this.bind(this.singleNodeCluster).to(Cluster.class);
            this.bind(this.singleNodeCluster).to(Service.class);
        }
    }
}

