/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import joptsimple.HelpFormatter;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionDescriptor;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.util.Utils;

public final class CmdLineUtils {
    private CmdLineUtils() {
    }

    public static OptionSet parseInitLine(String initLine, OptionParser parser) throws ProfilerException {
        OptionSet set;
        parser.accepts("help", "Display help.");
        NonOptionArgumentSpec nonOptions = parser.nonOptions();
        String[] split = initLine.split(";");
        for (int c = 0; c < split.length; ++c) {
            if (split[c].isEmpty()) continue;
            split[c] = "-" + split[c];
        }
        try {
            set = parser.parse(split);
        }
        catch (OptionException e) {
            try {
                StringWriter sw = new StringWriter();
                sw.append(e.getMessage());
                sw.append("\n");
                parser.printHelpOn((Writer)sw);
                ProfilerException pex = new ProfilerException(sw.toString());
                pex.addSuppressed((Throwable)e);
                throw pex;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        if (set.has("help")) {
            try {
                StringWriter sw = new StringWriter();
                parser.printHelpOn((Writer)sw);
                throw new ProfilerException(sw.toString());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        String s = (String)set.valueOf((OptionSpec)nonOptions);
        if (s != null && !s.isEmpty()) {
            throw new ProfilerException("Unhandled options: " + s + " in " + initLine);
        }
        return set;
    }

    public static final class ProfilerOptionFormatter
    implements HelpFormatter {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        private final String name;

        public ProfilerOptionFormatter(String name) {
            this.name = name;
        }

        public String format(Map<String, ? extends OptionDescriptor> options) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Usage: -prof <profiler-name>:opt1=value1,value2;opt2=value3");
            sb.append(LINE_SEPARATOR);
            sb.append(LINE_SEPARATOR);
            sb.append("Options accepted by ").append(this.name).append(':');
            for (OptionDescriptor optionDescriptor : options.values()) {
                try {
                    ProfilerOptionFormatter.lineFor(optionDescriptor, sb);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            return sb.toString();
        }

        private static void lineFor(OptionDescriptor d, Appendable line) throws IOException {
            StringBuilder o = new StringBuilder();
            o.append("  ");
            for (String str : d.options()) {
                if (d.representsNonOptions()) continue;
                o.append(str);
                if (!d.acceptsArguments()) continue;
                o.append('=');
                if (d.requiresArgument()) {
                    o.append('<');
                } else {
                    o.append('[');
                }
                o.append(d.argumentDescription());
                if (d.requiresArgument()) {
                    o.append('>');
                    continue;
                }
                o.append(']');
            }
            int optWidth = 35;
            line.append(String.format("%-35s", o.toString()));
            boolean first = true;
            String desc = d.description();
            List defaults = d.defaultValues();
            if (defaults != null && !defaults.isEmpty()) {
                desc = desc + " (default: " + defaults + ')';
            }
            for (String l : Utils.rewrap((String)desc)) {
                if (first) {
                    first = false;
                } else {
                    line.append(LINE_SEPARATOR);
                    line.append(String.format("%-35s", ""));
                }
                line.append(l);
            }
            line.append(LINE_SEPARATOR);
            line.append(LINE_SEPARATOR);
        }
    }
}

