/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.HelpFormatter;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.TextResult;
import org.openjdk.jmh.runner.IterationType;
import org.openjdk.jmh.util.Utils;
import org.spf4j.base.Runtime;
import org.spf4j.stackmonitor.CmdLineUtils;
import org.spf4j.stackmonitor.JFRControler;
import org.spf4j.stackmonitor.RecordingGranularity;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
public final class JmhDetailedJFRProfiler
implements ExternalProfiler,
InternalProfiler {
    private final File outDir;
    private final boolean debugNonSafePoints;
    private final String configName;
    private final Collection<String> flightRecorderOptions;
    private PostProcessor postProcessor;
    private volatile boolean measurementStarted;
    private final List<File> generated;
    private volatile long currentRecording;
    private File currentRecordingFile;
    private RecordingGranularity granularity;
    private final AtomicInteger measurementIterationCounter;
    private final AtomicInteger warmupIterationCounter;

    public JmhDetailedJFRProfiler() {
        this.flightRecorderOptions = new ArrayList<String>();
        this.postProcessor = null;
        this.measurementStarted = false;
        this.generated = new ArrayList<File>();
        this.measurementIterationCounter = new AtomicInteger(0);
        this.warmupIterationCounter = new AtomicInteger(0);
        this.outDir = new File(Runtime.USER_DIR);
        this.debugNonSafePoints = true;
        this.configName = "profile";
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public JmhDetailedJFRProfiler(String initLine) throws ProfilerException {
        block5: {
            this.flightRecorderOptions = new ArrayList<String>();
            this.postProcessor = null;
            this.measurementStarted = false;
            this.generated = new ArrayList<File>();
            this.measurementIterationCounter = new AtomicInteger(0);
            this.warmupIterationCounter = new AtomicInteger(0);
            OptionParser parser = new OptionParser();
            parser.formatHelpWith((HelpFormatter)new CmdLineUtils.ProfilerOptionFormatter("jfr_detail"));
            ArgumentAcceptingOptionSpec optDir = parser.accepts("dir", "Output directory to write jfr profile files.").withRequiredArg().ofType(String.class).describedAs("dir");
            ArgumentAcceptingOptionSpec optConfig = parser.accepts("configName", "Name of a predefined Flight Recorder configuration, e.g. profile or default.").withRequiredArg().ofType(String.class).describedAs("name").defaultsTo((Object)"profile", (Object[])new String[0]);
            ArgumentAcceptingOptionSpec optDebugNonSafePoints = parser.accepts("debugNonSafePoints", "Gather cpu samples asynchronously, rather than with safepoint bias.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo((Object)Boolean.TRUE, (Object[])new Boolean[0]);
            ArgumentAcceptingOptionSpec optStackDepth = parser.accepts("stackDepth", "Maximum number of stack frames collected for each event.").withRequiredArg().ofType(Integer.class).describedAs("frames");
            ArgumentAcceptingOptionSpec optGranularity = parser.accepts("detailLevel", "The detail granularity of the collected profiles. Can be iteration level, or warmup|measurement level aggregates").withRequiredArg().ofType(RecordingGranularity.class).withValuesConvertedBy((ValueConverter)new GranularityValueConverter()).defaultsTo((Object)RecordingGranularity.PER_ITERATION_TYPE, (Object[])new RecordingGranularity[0]).describedAs("granularity");
            ArgumentAcceptingOptionSpec optPostProcessor = parser.accepts("postProcessor", "The fully qualified name of a class that implements " + PostProcessor.class + ". This must have a public, no-argument constructor.").withRequiredArg().ofType(String.class).describedAs("fqcn");
            OptionSet set = CmdLineUtils.parseInitLine(initLine, parser);
            try {
                this.granularity = (RecordingGranularity)((Object)optGranularity.value(set));
                this.debugNonSafePoints = (Boolean)optDebugNonSafePoints.value(set);
                this.configName = (String)optConfig.value(set);
                if (set.has((OptionSpec)optStackDepth)) {
                    this.flightRecorderOptions.add("stackdepth=" + optStackDepth.value(set));
                }
                this.outDir = !set.has((OptionSpec)optDir) ? new File(Runtime.USER_DIR) : new File((String)set.valueOf((OptionSpec)optDir));
                if (!set.has((OptionSpec)optPostProcessor)) break block5;
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> postProcessorClass = loader.loadClass((String)optPostProcessor.value(set));
                    this.postProcessor = (PostProcessor)postProcessorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    ProfilerException pex = new ProfilerException((Exception)e);
                    pex.addSuppressed((Throwable)e);
                    throw pex;
                }
            }
            catch (OptionException e) {
                ProfilerException profilerException = new ProfilerException(e.getMessage());
                profilerException.addSuppressed((Throwable)e);
                throw profilerException;
            }
        }
    }

    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        IterationType type = iterationParams.getType();
        switch (type) {
            case WARMUP: {
                this.warmupIterationCounter.incrementAndGet();
                break;
            }
            case MEASUREMENT: {
                this.measurementIterationCounter.incrementAndGet();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Iteration type: " + type);
            }
        }
        if (!this.measurementStarted) {
            this.measurementStarted = true;
            switch (type) {
                case WARMUP: {
                    this.currentRecordingFile = new File(this.outDir, "w_" + benchmarkParams.id() + '_' + this.warmupIterationCounter.get() + ".jfr");
                    break;
                }
                case MEASUREMENT: {
                    this.currentRecordingFile = new File(this.outDir, "m_" + benchmarkParams.id() + '_' + this.measurementIterationCounter.get() + ".jfr");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported Iteration type: " + type);
                }
            }
            this.currentRecording = JFRControler.startRecording(this.currentRecordingFile, this.configName);
        }
    }

    private boolean isEndOfWarmupOrMeasuremenets(IterationParams iterationParams) {
        IterationType type = iterationParams.getType();
        switch (type) {
            case WARMUP: {
                return this.warmupIterationCounter.get() == iterationParams.getCount();
            }
            case MEASUREMENT: {
                return this.measurementIterationCounter.get() == iterationParams.getCount();
            }
        }
        throw new UnsupportedOperationException("Unsupported Iteration type: " + type);
    }

    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult iterationResult) {
        if (this.measurementStarted && (this.granularity == RecordingGranularity.PER_ITERATION || this.isEndOfWarmupOrMeasuremenets(iterationParams))) {
            JFRControler.closeRecording(this.currentRecording);
            this.currentRecording = -1L;
            this.measurementStarted = false;
            this.generated.add(this.currentRecordingFile);
            if (this.postProcessor != null) {
                this.generated.addAll(this.postProcessor.postProcess(benchmarkParams, this.currentRecordingFile));
            }
            return Collections.singletonList(this.result());
        }
        return Collections.emptyList();
    }

    private TextResult result() {
        StringWriter output = new StringWriter();
        try (PrintWriter pw = new PrintWriter(output);){
            pw.println("JFR profiler results:");
            for (File file : this.generated) {
                pw.print("  ");
                pw.println(file.getPath());
            }
            pw.flush();
        }
        return new TextResult(output.toString(), "jfr");
    }

    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    public Collection<String> addJVMOptions(BenchmarkParams params) {
        ArrayList<String> args = new ArrayList<String>();
        if (this.debugNonSafePoints) {
            args.add("-XX:+UnlockDiagnosticVMOptions");
            args.add("-XX:+DebugNonSafepoints");
        }
        if (!this.flightRecorderOptions.isEmpty()) {
            args.add("-XX:FlightRecorderOptions=" + Utils.join(this.flightRecorderOptions, (String)","));
        }
        args.add("-XX:+IgnoreUnrecognizedVMOptions");
        args.add("-XX:+FlightRecorder");
        return args;
    }

    public void beforeTrial(BenchmarkParams benchmarkParams) {
    }

    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        return Collections.emptyList();
    }

    public boolean allowPrintOut() {
        return true;
    }

    public boolean allowPrintErr() {
        return true;
    }

    public String getDescription() {
        return "JFR detailed profiler provider.";
    }

    public String toString() {
        return "JmhDetailedJFRProfiler{outDir=" + this.outDir + ", debugNonSafePoints=" + this.debugNonSafePoints + ", configName=" + this.configName + ", flightRecorderOptions=" + this.flightRecorderOptions + ", postProcessor=" + this.postProcessor + ", measurementStarted=" + this.measurementStarted + ", generated=" + this.generated + ", currentRecording=" + this.currentRecording + ", currentRecordingFile=" + this.currentRecordingFile + ", granularity=" + (Object)((Object)this.granularity) + ", measurementIterationCounter=" + this.measurementIterationCounter + ", warmupIterationCounter=" + this.warmupIterationCounter + '}';
    }

    private static class GranularityValueConverter
    implements ValueConverter<RecordingGranularity> {
        private GranularityValueConverter() {
        }

        public RecordingGranularity convert(String arg) {
            return RecordingGranularity.valueOf(arg);
        }

        public Class<RecordingGranularity> valueType() {
            return RecordingGranularity.class;
        }

        public String valuePattern() {
            return "PER_ITERATION_TYPE|PER_ITERATION";
        }
    }

    public static interface PostProcessor {
        public List<File> postProcess(BenchmarkParams var1, File var2);
    }
}

