/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.util.Map;
import jdk.management.jfr.FlightRecorderMXBean;

public final class JFRControler {
    private static final FlightRecorderMXBean JFR_BEAN = ManagementFactory.getPlatformMXBean(FlightRecorderMXBean.class);

    private JFRControler() {
    }

    public static long startRecording(File recordingFile, String predefinedConfigName) {
        long rec = JFR_BEAN.newRecording();
        JFR_BEAN.setPredefinedConfiguration(rec, predefinedConfigName);
        JFR_BEAN.setRecordingOptions(rec, (Map<String, String>)ImmutableMap.of((Object)"destination", (Object)recordingFile.getPath(), (Object)"disk", (Object)"true"));
        JFR_BEAN.startRecording(rec);
        return rec;
    }

    public static void closeRecording(long recording) {
        try {
            JFR_BEAN.closeRecording(recording);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

