/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.junit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.stackmonitor.FastStackCollector;
import org.spf4j.stackmonitor.Sampler;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
@NotThreadSafe
public final class Spf4jRunListener
extends RunListener {
    private static final Logger LOG = LoggerFactory.getLogger(Spf4jRunListener.class);
    private final Sampler sampler = new Sampler(Integer.getInteger("spf4j.junit.sampleTimeMillis", 5).intValue(), Integer.getInteger("spf4j.junit.dumpAfterMillis", Integer.MAX_VALUE).intValue(), t -> new FastStackCollector(false, true, new Thread[]{t}, new String[0]));
    private final File destinationFolder = new File(System.getProperty("spf4j.junit.destinationFolder", "target/junit-ssdump"));
    private volatile File lastWrittenFile;

    public Spf4jRunListener() {
        if (!this.destinationFolder.mkdirs() && !this.destinationFolder.canWrite()) {
            throw new ExceptionInInitializerError("Unable to write to " + this.destinationFolder);
        }
    }

    public void testFinished(Description description) throws IOException {
        File dump = this.sampler.dumpToFile(new File(this.destinationFolder, description.getDisplayName() + ".ssdump2"));
        if (dump != null) {
            LOG.info("Profile saved to {}", (Object)dump);
            this.lastWrittenFile = dump;
        }
    }

    public void testRunFinished(Result result) throws InterruptedException {
        this.sampler.stop();
    }

    public void testRunStarted(Description description) {
        this.sampler.start();
    }

    public Sampler getSampler() {
        return this.sampler;
    }

    public File getDestinationFolder() {
        return this.destinationFolder;
    }

    public File getLastWrittenFile() {
        return this.lastWrittenFile;
    }

    public String toString() {
        return "Spf4jRunListener{sampler=" + this.sampler + '}';
    }
}

