/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.base.Pair;
import org.spf4j.concurrent.UnboundedLoadingCache;
import org.spf4j.zel.vm.Program;
import org.spf4j.zel.vm.ResultCache;

@ThreadSafe
public final class SimpleResultCache
implements ResultCache {
    private final LoadingCache<Program, Pair<? extends ConcurrentMap<List<Object>, Object>, ? extends Cache<List<Object>, Object>>> cache;

    public SimpleResultCache() {
        this(100000);
    }

    public SimpleResultCache(int maxSize) {
        this.cache = new UnboundedLoadingCache(16, (CacheLoader)new CacheLoaderImpl(maxSize));
    }

    @Override
    public void putPermanentResult(Program program, @Nonnull List<Object> params, Object result) {
        Pair resultsMap = (Pair)this.cache.getUnchecked((Object)program);
        if (result == null) {
            ((ConcurrentMap)resultsMap.getFirst()).put(params, ResultCache.NULL);
        } else {
            ((ConcurrentMap)resultsMap.getFirst()).put(params, result);
        }
    }

    @Override
    public void putTransientResult(Program program, @Nonnull List<Object> params, Object result) {
        Pair resultsMap = (Pair)this.cache.getUnchecked((Object)program);
        if (result == null) {
            ((Cache)resultsMap.getSecond()).put(params, ResultCache.NULL);
        } else {
            ((Cache)resultsMap.getSecond()).put(params, result);
        }
    }

    @Override
    public Object getResult(Program program, @Nonnull List<Object> params, Callable<Object> compute) throws ExecutionException {
        Pair prCache = (Pair)this.cache.getUnchecked((Object)program);
        Object result = ((ConcurrentMap)prCache.getFirst()).get(params);
        if (result == null) {
            result = ((Cache)prCache.getSecond()).get(params, (Callable)new CallableNullWrapper(compute));
        }
        if (result == ResultCache.NULL) {
            result = null;
        }
        return result;
    }

    public String toString() {
        return "SimpleResultCache{cache=" + this.cache + '}';
    }

    private static class CallableNullWrapper
    implements Callable<Object> {
        private final Callable<Object> compute;

        public CallableNullWrapper(Callable<Object> compute) {
            this.compute = compute;
        }

        @Override
        public Object call() throws Exception {
            Object result = this.compute.call();
            if (result == null) {
                return ResultCache.NULL;
            }
            return result;
        }
    }

    static class CacheLoaderImpl
    extends CacheLoader<Program, Pair<? extends ConcurrentMap<List<Object>, Object>, ? extends Cache<List<Object>, Object>>> {
        private final int maxSize;

        public CacheLoaderImpl(int maxSize) {
            this.maxSize = maxSize;
        }

        public Pair<? extends ConcurrentMap<List<Object>, Object>, ? extends Cache<List<Object>, Object>> load(Program key) throws Exception {
            Cache trCache = CacheBuilder.newBuilder().maximumSize((long)this.maxSize).build();
            return Pair.of(new ConcurrentHashMap(), (Object)trCache);
        }
    }
}

