/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.instr;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.instr.SyncAsyncCallable;
import org.spf4j.zel.vm.ExecutionContext;
import org.spf4j.zel.vm.Method;
import org.spf4j.zel.vm.Program;
import org.spf4j.zel.vm.SuspendedException;
import org.spf4j.zel.vm.ZExecutionException;

public final class CALL
extends Instruction {
    private static final long serialVersionUID = 759722625722456554L;
    public static final Instruction INSTANCE = new CALL();

    private CALL() {
    }

    @Override
    @SuppressWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
    public int execute(ExecutionContext context) throws ExecutionException, InterruptedException, SuspendedException {
        Integer nrParams = (Integer)context.pop();
        Object function = context.peekFromTop(nrParams);
        if (function instanceof Program) {
            Object obj;
            Program p = (Program)function;
            switch (p.getType()) {
                case DETERMINISTIC: {
                    Object[] parameters = CALL.getParamsSync(context, nrParams);
                    ExecutionContext nctx = context.getSubProgramContext(p, parameters);
                    obj = context.resultCache.getResult(p, Arrays.asList(parameters), new SyncAsyncCallable(nctx));
                    break;
                }
                case NONDETERMINISTIC: {
                    Object[] parameters = CALL.getParams(context, nrParams);
                    ExecutionContext nctx = context.getSubProgramContext(p, parameters);
                    obj = Program.executeSyncOrAsync(nctx);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(p.getType().toString());
                }
            }
            context.push(obj);
        } else if (function instanceof Method) {
            Object[] parameters = CALL.getParamsSync(context, nrParams);
            try {
                context.push(((Method)function).invoke(context, parameters));
            }
            catch (RuntimeException ex) {
                throw new ZExecutionException("cannot invoke " + function, ex);
            }
        } else {
            throw new ZExecutionException("cannot invoke " + function);
        }
        return 1;
    }

    static Object[] getParamsSync(ExecutionContext context, Integer nrParams) throws SuspendedException, ExecutionException {
        Object[] parameters;
        try {
            parameters = context.popSyncStackVals(nrParams);
        }
        catch (SuspendedException e) {
            context.push(nrParams);
            throw e;
        }
        context.pop();
        return parameters;
    }

    static Object[] getParams(ExecutionContext context, Integer nrParams) throws SuspendedException {
        Object[] parameters = context.popStackVals(nrParams);
        context.pop();
        return parameters;
    }

    @Override
    public Object[] getParameters() {
        return org.spf4j.base.Arrays.EMPTY_OBJ_ARRAY;
    }
}

