/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.operators;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.spf4j.zel.operators.Operator;

public final class BigIntegerOperators {
    private BigIntegerOperators() {
    }

    public static final class Pow
    implements Operator<BigInteger, Number, Number> {
        @Override
        public Number op(BigInteger a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a.pow(b.intValue());
            }
            if (claszB.equals(Long.class)) {
                if (((Long)b).compareTo((Long)Integer.MAX_VALUE) > 0) {
                    return Math.pow(a.doubleValue(), ((Long)b).longValue());
                }
                return a.pow(b.intValue());
            }
            if (claszB.equals(Double.class)) {
                return Math.pow(a.doubleValue(), (Double)b);
            }
            if (claszB.equals(Float.class)) {
                return Math.pow(a.doubleValue(), (Double)b);
            }
            if (claszB.equals(BigInteger.class)) {
                return a.pow(b.intValue());
            }
            if (claszB.equals(BigDecimal.class)) {
                return Math.pow(a.doubleValue(), b.doubleValue());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Mod
    implements Operator<BigInteger, Number, Number> {
        @Override
        public Number op(BigInteger a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Long.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a.mod(BigInteger.valueOf(b.longValue()));
            }
            if (claszB.equals(Double.class)) {
                return a.mod(BigInteger.valueOf(b.longValue()));
            }
            if (claszB.equals(Float.class)) {
                return a.mod(BigInteger.valueOf(b.longValue()));
            }
            if (claszB.equals(BigInteger.class)) {
                return a.mod((BigInteger)b).intValue();
            }
            if (claszB.equals(BigDecimal.class)) {
                return a.mod(((BigDecimal)b).toBigInteger()).intValue();
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Div
    implements Operator<BigInteger, Number, Number> {
        @Override
        public Number op(BigInteger a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Long.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a.divide(BigInteger.valueOf(b.longValue()));
            }
            if (claszB.equals(Double.class)) {
                return a.doubleValue() / (Double)b;
            }
            if (claszB.equals(Float.class)) {
                return a.doubleValue() / (double)((Float)b).floatValue();
            }
            if (claszB.equals(BigInteger.class)) {
                return a.divide((BigInteger)b).intValue();
            }
            if (claszB.equals(BigDecimal.class)) {
                return new BigDecimal(a).divide((BigDecimal)b, (MathContext)MATH_CONTEXT.get()).intValue();
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Mul
    implements Operator<BigInteger, Number, Number> {
        @Override
        public Number op(BigInteger a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Long.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a.multiply(BigInteger.valueOf(b.longValue()));
            }
            if (claszB.equals(Double.class)) {
                return a.doubleValue() * (Double)b;
            }
            if (claszB.equals(Float.class)) {
                return a.doubleValue() * (double)((Float)b).floatValue();
            }
            if (claszB.equals(BigInteger.class)) {
                return a.multiply((BigInteger)b);
            }
            if (claszB.equals(BigDecimal.class)) {
                return new BigDecimal(a).multiply((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Sub
    implements Operator<BigInteger, Number, Number> {
        @Override
        public Number op(BigInteger a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Long.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a.subtract(BigInteger.valueOf(b.longValue()));
            }
            if (claszB.equals(Double.class)) {
                return a.doubleValue() - (Double)b;
            }
            if (claszB.equals(Float.class)) {
                return a.doubleValue() - (double)((Float)b).floatValue();
            }
            if (claszB.equals(BigInteger.class)) {
                return a.subtract((BigInteger)b);
            }
            if (claszB.equals(BigDecimal.class)) {
                return new BigDecimal(a).subtract((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Add
    implements Operator<BigInteger, Number, Number> {
        @Override
        public Number op(BigInteger a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Long.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a.add(BigInteger.valueOf(b.longValue()));
            }
            if (claszB.equals(Double.class)) {
                return (Double)b + a.doubleValue();
            }
            if (claszB.equals(Float.class)) {
                return (Double)b + a.doubleValue();
            }
            if (claszB.equals(BigInteger.class)) {
                return ((BigInteger)b).add(a);
            }
            if (claszB.equals(BigDecimal.class)) {
                return ((BigDecimal)b).add(new BigDecimal(a), (MathContext)MATH_CONTEXT.get());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }
}

