/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.instr;

import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.instr.SyncCallable;
import org.spf4j.zel.vm.AssignableValue;
import org.spf4j.zel.vm.ExecutionContext;
import org.spf4j.zel.vm.Method;
import org.spf4j.zel.vm.Program;
import org.spf4j.zel.vm.SuspendedException;
import org.spf4j.zel.vm.ZExecutionException;

public final class CALLREF
extends Instruction {
    private static final long serialVersionUID = 1L;
    public static final Instruction INSTANCE = new CALLREF();

    private CALLREF() {
    }

    @Override
    public int execute(ExecutionContext context) throws ExecutionException, InterruptedException, SuspendedException {
        Object[] parameters;
        Integer nrParams = (Integer)context.pop();
        try {
            parameters = context.popSyncStackVals(nrParams);
        }
        catch (SuspendedException e) {
            context.push(nrParams);
            throw e;
        }
        Object function = ((AssignableValue)context.pop()).get();
        context.push(new FunctionDeref(context, function, parameters));
        return 1;
    }

    @Override
    public Object[] getParameters() {
        return org.spf4j.base.Arrays.EMPTY_OBJ_ARRAY;
    }

    private static final class FunctionDeref
    implements AssignableValue {
        private final ExecutionContext context;
        private final Object function;
        private final Object[] parameters;

        public FunctionDeref(ExecutionContext context, Object function, Object[] parameters) {
            this.context = context;
            this.function = function;
            this.parameters = parameters;
        }

        @Override
        public void assign(Object object) {
            this.context.resultCache.putPermanentResult((Program)this.function, Arrays.asList(this.parameters), object);
        }

        @Override
        public Object get() throws ExecutionException, InterruptedException {
            if (this.function instanceof Program) {
                Object obj;
                Program p = (Program)this.function;
                switch (p.getType()) {
                    case DETERMINISTIC: {
                        ExecutionContext nctx = this.context.getSyncSubProgramContext(p, this.parameters);
                        obj = this.context.resultCache.getResult(p, Arrays.asList(this.parameters), new SyncCallable(nctx));
                        break;
                    }
                    case NONDETERMINISTIC: {
                        ExecutionContext nctx = this.context.getSyncSubProgramContext(p, this.parameters);
                        obj = Program.executeSync(nctx);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(p.getType().toString());
                    }
                }
                return obj;
            }
            if (this.function instanceof Method) {
                try {
                    return ((Method)this.function).invoke(this.context, this.parameters);
                }
                catch (Exception ex) {
                    throw new ZExecutionException("cannot invoke " + this.function, ex);
                }
            }
            throw new ZExecutionException("cannot invoke " + this.function);
        }
    }
}

