/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.operators;

import com.google.common.math.LongMath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.spf4j.zel.operators.Operator;

@SuppressFBWarnings(value={"NS_DANGEROUS_NON_SHORT_CIRCUIT", "NS_NON_SHORT_CIRCUIT"})
public final class LongOperators {
    private LongOperators() {
    }

    private static Number powLongInt(Long a, Number b) {
        long result;
        try {
            result = LongMath.checkedPow((long)a, (int)b.intValue());
        }
        catch (ArithmeticException e) {
            return BigInteger.valueOf(a).pow(b.intValue());
        }
        return result;
    }

    public static final class Pow
    implements Operator<Long, Number, Number> {
        @Override
        public Number op(Long pa, Number b) {
            long a = pa;
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return LongOperators.powLongInt(a, b);
            }
            if (claszB.equals(Long.class)) {
                if (((Long)b).compareTo((Long)Integer.MAX_VALUE) > 0) {
                    return Math.pow(a, ((Long)b).longValue());
                }
                return LongOperators.powLongInt(a, b.intValue());
            }
            if (claszB.equals(Double.class)) {
                return Math.pow(a, (Double)b);
            }
            if (claszB.equals(Float.class)) {
                return Math.pow(a, (Double)b);
            }
            if (claszB.equals(BigInteger.class)) {
                return BigInteger.valueOf(a).pow(b.intValue());
            }
            if (claszB.equals(BigDecimal.class)) {
                return BigDecimal.valueOf(a).pow(b.intValue());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Mod
    implements Operator<Long, Number, Number> {
        @Override
        public Number op(Long pa, Number b) {
            long a = pa;
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Long.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a % b.longValue();
            }
            if (claszB.equals(Double.class)) {
                return a % b.longValue();
            }
            if (claszB.equals(Float.class)) {
                return a % b.longValue();
            }
            if (claszB.equals(BigInteger.class)) {
                return BigInteger.valueOf(a).mod((BigInteger)b).intValue();
            }
            if (claszB.equals(BigDecimal.class)) {
                return BigInteger.valueOf(a).mod(((BigDecimal)b).toBigInteger()).intValue();
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Div
    implements Operator<Long, Number, Number> {
        @Override
        public Number op(Long pa, Number b) {
            long a = pa;
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Long.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a / b.longValue();
            }
            if (claszB.equals(Double.class)) {
                return (double)a / (Double)b;
            }
            if (claszB.equals(Float.class)) {
                return (double)a / (double)((Float)b).floatValue();
            }
            if (claszB.equals(BigInteger.class)) {
                return BigInteger.valueOf(a).divide((BigInteger)b).intValue();
            }
            if (claszB.equals(BigDecimal.class)) {
                return BigDecimal.valueOf(a).divide((BigDecimal)b, (MathContext)MATH_CONTEXT.get()).intValue();
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Mul
    implements Operator<Long, Number, Number> {
        @Override
        public Number op(Long pa, Number b) {
            long a = pa;
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Long.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                long bb = b.longValue();
                int leadingZeros = Long.numberOfLeadingZeros(a) + Long.numberOfLeadingZeros(a ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(bb) + Long.numberOfLeadingZeros(bb ^ 0xFFFFFFFFFFFFFFFFL);
                if (leadingZeros > 65) {
                    return a * bb;
                }
                if (leadingZeros < 64) {
                    return BigInteger.valueOf(a).multiply(BigInteger.valueOf(bb));
                }
                if (!(a >= 0L | bb != Long.MIN_VALUE)) {
                    return BigInteger.valueOf(a).multiply(BigInteger.valueOf(bb));
                }
                long result = a * bb;
                if (a != 0L && result / a != bb) {
                    return BigInteger.valueOf(a).multiply(BigInteger.valueOf(bb));
                }
                return result;
            }
            if (claszB.equals(Double.class)) {
                return (double)a * (Double)b;
            }
            if (claszB.equals(Float.class)) {
                return (double)a * (double)((Float)b).floatValue();
            }
            if (claszB.equals(BigInteger.class)) {
                return BigInteger.valueOf(a).multiply((BigInteger)b);
            }
            if (claszB.equals(BigDecimal.class)) {
                return BigDecimal.valueOf(a).multiply((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Sub
    implements Operator<Long, Number, Number> {
        @Override
        public Number op(Long pa, Number b) {
            long a = pa;
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Long.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                long result;
                long bb = b.longValue();
                if ((a ^ bb) < 0L | (a ^ (result = a - bb)) >= 0L) {
                    return result;
                }
                return BigInteger.valueOf(a).subtract(BigInteger.valueOf(bb));
            }
            if (claszB.equals(Double.class)) {
                return (double)a - (Double)b;
            }
            if (claszB.equals(Float.class)) {
                return (double)a - (double)((Float)b).floatValue();
            }
            if (claszB.equals(BigInteger.class)) {
                return BigInteger.valueOf(a).subtract((BigInteger)b);
            }
            if (claszB.equals(BigDecimal.class)) {
                return BigDecimal.valueOf(a).subtract((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Add
    implements Operator<Long, Number, Number> {
        @Override
        public Number op(Long pa, Number b) {
            long a = pa;
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Long.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                long result;
                long bb = b.longValue();
                if ((a ^ bb) < 0L | (a ^ (result = a + bb)) >= 0L) {
                    return result;
                }
                return BigInteger.valueOf(a).add(BigInteger.valueOf(bb));
            }
            if (claszB.equals(Double.class)) {
                return (Double)b + (double)a;
            }
            if (claszB.equals(Float.class)) {
                return (Double)b + (double)a;
            }
            if (claszB.equals(BigInteger.class)) {
                return ((BigInteger)b).add(BigInteger.valueOf(a));
            }
            if (claszB.equals(BigDecimal.class)) {
                return ((BigDecimal)b).add(BigDecimal.valueOf(a), (MathContext)MATH_CONTEXT.get());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }
}

