/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class ZelFrame
implements Serializable {
    private static final ConcurrentMap<String, String> SOURCES = new ConcurrentHashMap<String, String>();
    private static final AtomicInteger IDX = new AtomicInteger();
    private static final long serialVersionUID = 1L;
    private final String programName;
    private final String source;
    private final int index;

    public static String newSource(String sourceDetail) {
        String id = "zel_" + IDX.getAndIncrement();
        SOURCES.put(id, sourceDetail);
        return id;
    }

    public static String getDetail(String id) {
        return (String)SOURCES.get(id);
    }

    public ZelFrame(String programName, String source, int index) {
        this.programName = programName;
        this.index = index;
        this.source = source;
    }

    public String toString() {
        return this.programName + '(' + this.source + ':' + this.index + ')';
    }

    public String getProgramName() {
        return this.programName;
    }

    public String getSource() {
        return this.source;
    }

    public int getIndex() {
        return this.index;
    }
}

