/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.operators;

import com.google.common.math.IntMath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.spf4j.zel.operators.AbstractOps;
import org.spf4j.zel.operators.Operator;

@SuppressFBWarnings(value={"NS_NON_SHORT_CIRCUIT", "SIC_INNER_SHOULD_BE_STATIC_ANON"})
public final class IntegerOperators {
    private IntegerOperators() {
    }

    private static Number powIntInt(Integer a, Number b) {
        int result;
        try {
            result = IntMath.checkedPow((int)a, (int)b.intValue());
        }
        catch (ArithmeticException e) {
            return BigInteger.valueOf(a.intValue()).pow(b.intValue());
        }
        return result;
    }

    public static final class Pow
    extends AbstractOps<Integer> {
        public Pow() {
            Operator<Integer, Number, Number> isbc = new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return IntegerOperators.powIntInt(a, b);
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    if (((Long)b).compareTo((Long)Integer.MAX_VALUE) > 0) {
                        return Math.pow(a.intValue(), ((Long)b).longValue());
                    }
                    return IntegerOperators.powIntInt(a, b.intValue());
                }
            });
            Operator<Integer, Number, Number> dfOp = new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return Math.pow(a.intValue(), b.doubleValue());
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return BigInteger.valueOf(a.intValue()).pow(b.intValue());
                }
            });
            this.operations.put(BigDecimal.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return BigDecimal.valueOf(a.intValue()).pow(b.intValue());
                }
            });
        }
    }

    public static final class Mod
    extends AbstractOps<Integer> {
        public Mod() {
            Operator<Integer, Number, Number> isbc = new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    long result = (long)a.intValue() % (long)b.intValue();
                    return (int)result;
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return (long)a.intValue() % b.longValue();
                }
            });
            Operator<Integer, Number, Number> dfOp = new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return (long)a.intValue() % b.longValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return BigInteger.valueOf(a.intValue()).mod((BigInteger)b).intValue();
                }
            });
            this.operations.put(BigDecimal.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return BigInteger.valueOf(a.intValue()).mod(((BigDecimal)b).toBigInteger()).intValue();
                }
            });
        }
    }

    public static final class Div
    extends AbstractOps<Integer> {
        public Div() {
            Operator<Integer, Number, Number> isbc = new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return (int)((long)a.intValue() / (long)b.intValue());
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    long aa = a.intValue();
                    long bb = (Long)b;
                    return aa / bb;
                }
            });
            Operator<Integer, Number, Number> dfOp = new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return (double)a.intValue() / b.doubleValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return BigInteger.valueOf(a.intValue()).divide((BigInteger)b).intValue();
                }
            });
            this.operations.put(BigDecimal.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return BigDecimal.valueOf(a.intValue()).divide((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
                }
            });
        }
    }

    public static final class Mul
    extends AbstractOps<Integer> {
        public Mul() {
            Operator<Integer, Number, Number> isbc = new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    long result = (long)a.intValue() * (long)b.intValue();
                    if (result == (long)((int)result)) {
                        return (int)result;
                    }
                    return result;
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    long aa = a.intValue();
                    long bb = (Long)b;
                    int leadingZeros = Long.numberOfLeadingZeros(aa) + Long.numberOfLeadingZeros(aa ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(bb) + Long.numberOfLeadingZeros(bb ^ 0xFFFFFFFFFFFFFFFFL);
                    if (leadingZeros > 65) {
                        return aa * bb;
                    }
                    if (leadingZeros < 64) {
                        return BigInteger.valueOf(aa).multiply(BigInteger.valueOf(bb));
                    }
                    if (!(aa >= 0L | bb != Long.MIN_VALUE)) {
                        return BigInteger.valueOf(aa).multiply(BigInteger.valueOf(bb));
                    }
                    long tentativeResult = aa * bb;
                    if (aa != 0L && tentativeResult / aa != bb) {
                        return BigInteger.valueOf(aa).multiply(BigInteger.valueOf(bb));
                    }
                    return tentativeResult;
                }
            });
            Operator<Integer, Number, Number> dfOp = new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return (double)a.intValue() * b.doubleValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return BigInteger.valueOf(a.intValue()).multiply((BigInteger)b);
                }
            });
            this.operations.put(BigDecimal.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return BigDecimal.valueOf(a.intValue()).multiply((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
                }
            });
        }
    }

    public static final class Sub
    extends AbstractOps<Integer> {
        public Sub() {
            Operator<Integer, Number, Number> isbc = new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    long result = (long)a.intValue() - (long)b.intValue();
                    if (result == (long)((int)result)) {
                        return (int)result;
                    }
                    return result;
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    long result;
                    long bb;
                    long aa = a.intValue();
                    if ((aa ^ (bb = ((Long)b).longValue())) < 0L | (aa ^ (result = aa - bb)) >= 0L) {
                        return result;
                    }
                    BigInteger rr = BigInteger.valueOf(bb);
                    return rr.add(BigInteger.valueOf(aa));
                }
            });
            Operator<Integer, Number, Number> dfOp = new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return (double)a.intValue() - b.doubleValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return BigInteger.valueOf(a.intValue()).subtract((BigInteger)b);
                }
            });
            this.operations.put(BigDecimal.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return BigDecimal.valueOf(a.intValue()).subtract((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
                }
            });
        }
    }

    public static final class Add
    extends AbstractOps<Integer> {
        public Add() {
            Operator<Integer, Number, Number> isbc = new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    long result = (long)a.intValue() + (long)b.intValue();
                    if (result == (long)((int)result)) {
                        return (int)result;
                    }
                    return result;
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    long result;
                    long bb;
                    long aa = a.intValue();
                    if ((aa ^ (bb = ((Long)b).longValue())) < 0L | (aa ^ (result = aa + bb)) >= 0L) {
                        return result;
                    }
                    BigInteger rr = BigInteger.valueOf(bb);
                    return rr.add(BigInteger.valueOf(aa));
                }
            });
            Operator<Integer, Number, Number> dfOp = new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return b.doubleValue() + (double)a.intValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return ((BigInteger)b).add(BigInteger.valueOf(a.intValue()));
                }
            });
            this.operations.put(BigDecimal.class, new Operator<Integer, Number, Number>(){

                @Override
                public Number op(Integer a, Number b) {
                    return ((BigDecimal)b).add(BigDecimal.valueOf(a.intValue()), (MathContext)MATH_CONTEXT.get());
                }
            });
        }
    }
}

