/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.instr;

import java.math.MathContext;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.operators.Operator;
import org.spf4j.zel.vm.ExecutionContext;

public final class MCTX
extends Instruction {
    private static final long serialVersionUID = 6127414006563169983L;
    private final int precission;

    public MCTX(int precission) {
        this.precission = precission;
    }

    @Override
    public int execute(ExecutionContext context) {
        switch (this.precission) {
            case 32: {
                context.mathContext = MathContext.DECIMAL32;
                break;
            }
            case 64: {
                context.mathContext = MathContext.DECIMAL64;
                break;
            }
            case 128: {
                context.mathContext = MathContext.DECIMAL128;
                break;
            }
            default: {
                context.mathContext = MathContext.DECIMAL128;
            }
        }
        Operator.MATH_CONTEXT.set(context.mathContext);
        return 1;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.precission};
    }
}

