/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.instr;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.spf4j.zel.instr.AsyncCallable;
import org.spf4j.zel.instr.CALL;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.vm.ExecutionContext;
import org.spf4j.zel.vm.Method;
import org.spf4j.zel.vm.Program;
import org.spf4j.zel.vm.SuspendedException;
import org.spf4j.zel.vm.VMExecutor;
import org.spf4j.zel.vm.VMFuture;
import org.spf4j.zel.vm.ZExecutionException;

public final class CALLA
extends Instruction {
    private static final long serialVersionUID = 759722625722456554L;
    private final int nrParameters;

    public CALLA(int nrParameters) {
        this.nrParameters = nrParameters;
    }

    @Override
    @SuppressWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
    public int execute(ExecutionContext context) throws ExecutionException, InterruptedException, SuspendedException {
        Object function = context.peekFromTop(this.nrParameters);
        if (function instanceof Program) {
            Object obj;
            Program p = (Program)function;
            switch (p.getType()) {
                case DETERMINISTIC: {
                    Object[] parameters = CALL.getParamsSync(context, this.nrParameters);
                    ExecutionContext nctx = context.getSubProgramContext(p, parameters);
                    obj = context.resultCache.getResult(p, Arrays.asList(parameters), new AsyncCallable(nctx));
                    break;
                }
                case NONDETERMINISTIC: {
                    Object[] parameters = CALL.getParams(context, this.nrParameters);
                    ExecutionContext nctx = context.getSubProgramContext(p, parameters);
                    obj = Program.executeAsync(nctx);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(p.getType().toString());
                }
            }
            context.push(obj);
        } else if (function instanceof Method) {
            Object[] parameters = CALL.getParamsSync(context, this.nrParameters);
            Future<Object> obj = context.execService.submit(new MethodVMExecutor(function, context, parameters));
            context.push(obj);
        } else {
            throw new ZExecutionException("cannot invoke " + function);
        }
        return 1;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.nrParameters};
    }

    private static class MethodVMExecutor
    implements VMExecutor.Suspendable<Object> {
        private final Object function;
        private final ExecutionContext context;
        private final Object[] parameters;

        MethodVMExecutor(Object function, ExecutionContext context, Object[] parameters) {
            this.function = function;
            this.context = context;
            this.parameters = parameters;
        }

        @Override
        public Object call() {
            return ((Method)this.function).invoke(this.context, this.parameters);
        }

        @Override
        public List<VMFuture<Object>> getSuspendedAt() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

