/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

public final class WildCardMatcher {
    private final String wildcardExp;

    public WildCardMatcher(String wildcardExp) {
        this.wildcardExp = wildcardExp;
    }

    public boolean match(String str) {
        return WildCardMatcher.match(this.wildcardExp, str);
    }

    public static boolean match(String wildcard, String v) {
        int i = 0;
        int j = 0;
        int length = wildcard.length();
        while (i < length) {
            char some2 = wildcard.charAt(i);
            if (some2 != v.charAt(j)) {
                if (some2 == '*') {
                    if (++i == length) {
                        return true;
                    }
                    char some = wildcard.charAt(i);
                    while (some != v.charAt(j)) {
                        ++j;
                    }
                    --j;
                } else if (some2 != '?') {
                    return false;
                }
            }
            ++i;
            ++j;
        }
        return j == v.length();
    }

    public String getJavaRegexp() {
        StringBuilder buff = new StringBuilder();
        int length = this.wildcardExp.length();
        block5: for (int i = 0; i < length; ++i) {
            char c = this.wildcardExp.charAt(i);
            switch (c) {
                case '*': {
                    buff.append("[^\\[\\]\\.]+");
                    continue block5;
                }
                case '?': {
                    buff.append('.');
                    continue block5;
                }
                case '.': 
                case '[': 
                case ']': {
                    buff.append('\\').append(c);
                    continue block5;
                }
                default: {
                    buff.append(c);
                }
            }
        }
        return buff.toString();
    }

    public static boolean isWildcardMatcher(String str) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c != '*' && c != '?') continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return '`' + this.wildcardExp + '`';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WildCardMatcher other = (WildCardMatcher)obj;
        return !(this.wildcardExp != null ? !this.wildcardExp.equals(other.wildcardExp) : other.wildcardExp != null);
    }

    public int hashCode() {
        int hash = 5;
        return 43 * hash + (this.wildcardExp != null ? this.wildcardExp.hashCode() : 0);
    }
}

