/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.spf4j.zel.vm.ZelFrame;

public final class ZExecutionException
extends ExecutionException {
    private static final long serialVersionUID = 8823469923479284L;
    private final Object payload;
    private final List<ZelFrame> zelframes = new ArrayList<ZelFrame>();

    public ZExecutionException(String message, Exception e) {
        super(message, e);
        this.payload = null;
    }

    public ZExecutionException(Exception e) {
        super(e);
        this.payload = null;
    }

    public ZExecutionException(String msg) {
        super(msg);
        this.payload = null;
    }

    public ZExecutionException(Object object) {
        this.payload = object;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void addZelFrame(ZelFrame frame) {
        this.zelframes.add(frame);
    }

    public List<ZelFrame> getZelframes() {
        return this.zelframes;
    }

    @Override
    public String toString() {
        String msg = super.toString();
        StringBuilder result = new StringBuilder(1024);
        result.append(msg);
        result.append('\n');
        result.append("Zel trace:\n");
        HashSet<String> sourceIds = new HashSet<String>();
        for (ZelFrame frame : this.zelframes) {
            result.append(frame);
            result.append('\n');
            sourceIds.add(frame.getSource());
        }
        for (String sourceId : sourceIds) {
            result.append(sourceId).append(":\n");
            result.append(ZelFrame.getDetail(sourceId)).append("\n");
        }
        return result.toString();
    }
}

