/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.operators;

import com.google.common.math.IntMath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.spf4j.zel.operators.Operator;

@SuppressFBWarnings(value={"NS_NON_SHORT_CIRCUIT"})
public final class IntegerOperators {
    private IntegerOperators() {
    }

    private static Number powIntInt(Integer a, Number b) {
        int result;
        try {
            result = IntMath.checkedPow((int)a, (int)b.intValue());
        }
        catch (ArithmeticException e) {
            return BigInteger.valueOf(a.intValue()).pow(b.intValue());
        }
        return result;
    }

    public static final class Pow
    implements Operator<Integer, Number, Number> {
        @Override
        public Number op(Integer a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB == Integer.class || claszB == Short.class || claszB == Byte.class) {
                return IntegerOperators.powIntInt(a, b);
            }
            if (claszB == Long.class) {
                if (((Long)b).compareTo((Long)Integer.MAX_VALUE) > 0) {
                    return Math.pow(a.intValue(), ((Long)b).longValue());
                }
                return IntegerOperators.powIntInt(a, b.intValue());
            }
            if (claszB == Double.class) {
                return Math.pow(a.intValue(), (Double)b);
            }
            if (claszB == Float.class) {
                return Math.pow(a.intValue(), (Double)b);
            }
            if (claszB == BigInteger.class) {
                return BigInteger.valueOf(a.intValue()).pow(b.intValue());
            }
            if (claszB == BigDecimal.class) {
                return BigDecimal.valueOf(a.intValue()).pow(b.intValue());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Mod
    implements Operator<Integer, Number, Number> {
        @Override
        public Number op(Integer a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB == Integer.class || claszB == Short.class || claszB == Byte.class) {
                long result = (long)a.intValue() % (long)b.intValue();
                return (int)result;
            }
            if (claszB == Long.class) {
                return (long)a.intValue() % b.longValue();
            }
            if (claszB == Double.class) {
                return (long)a.intValue() % b.longValue();
            }
            if (claszB == Float.class) {
                return (long)a.intValue() % b.longValue();
            }
            if (claszB == BigInteger.class) {
                return BigInteger.valueOf(a.intValue()).mod((BigInteger)b).intValue();
            }
            if (claszB == BigDecimal.class) {
                return BigInteger.valueOf(a.intValue()).mod(((BigDecimal)b).toBigInteger()).intValue();
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Div
    implements Operator<Integer, Number, Number> {
        @Override
        public Number op(Integer a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB == Integer.class || claszB == Short.class || claszB == Byte.class) {
                long result = (long)a.intValue() / (long)b.intValue();
                return (int)result;
            }
            if (claszB == Long.class) {
                long aa = a.intValue();
                long bb = (Long)b;
                return aa / bb;
            }
            if (claszB == Double.class) {
                return (double)a.intValue() / (Double)b;
            }
            if (claszB == Float.class) {
                return (double)a.intValue() / (double)((Float)b).floatValue();
            }
            if (claszB == BigInteger.class) {
                return BigInteger.valueOf(a.intValue()).divide((BigInteger)b).intValue();
            }
            if (claszB == BigDecimal.class) {
                return BigDecimal.valueOf(a.intValue()).divide((BigDecimal)b, (MathContext)MATH_CONTEXT.get()).intValue();
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Mul
    implements Operator<Integer, Number, Number> {
        @Override
        public Number op(Integer a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB == Integer.class || claszB == Short.class || claszB == Byte.class) {
                long result = (long)a.intValue() * (long)b.intValue();
                if (result == (long)((int)result)) {
                    return (int)result;
                }
                return result;
            }
            if (claszB == Long.class) {
                long aa = a.intValue();
                long bb = (Long)b;
                int leadingZeros = Long.numberOfLeadingZeros(aa) + Long.numberOfLeadingZeros(aa ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(bb) + Long.numberOfLeadingZeros(bb ^ 0xFFFFFFFFFFFFFFFFL);
                if (leadingZeros > 65) {
                    return aa * bb;
                }
                if (leadingZeros < 64) {
                    return BigInteger.valueOf(aa).multiply(BigInteger.valueOf(bb));
                }
                if (!(aa >= 0L | bb != Long.MIN_VALUE)) {
                    return BigInteger.valueOf(aa).multiply(BigInteger.valueOf(bb));
                }
                long tentativeResult = aa * bb;
                if (aa != 0L && tentativeResult / aa != bb) {
                    return BigInteger.valueOf(aa).multiply(BigInteger.valueOf(bb));
                }
                return tentativeResult;
            }
            if (claszB == Double.class) {
                return (double)a.intValue() * (Double)b;
            }
            if (claszB == Float.class) {
                return (double)a.intValue() * (double)((Float)b).floatValue();
            }
            if (claszB == BigInteger.class) {
                return BigInteger.valueOf(a.intValue()).multiply((BigInteger)b);
            }
            if (claszB == BigDecimal.class) {
                return BigDecimal.valueOf(a.intValue()).multiply((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Sub
    implements Operator<Integer, Number, Number> {
        @Override
        public Number op(Integer a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB == Integer.class || claszB == Short.class || claszB == Byte.class) {
                long result = (long)a.intValue() - (long)b.intValue();
                if (result == (long)((int)result)) {
                    return (int)result;
                }
                return result;
            }
            if (claszB == Long.class) {
                long result;
                long bb;
                long aa = a.intValue();
                if ((aa ^ (bb = ((Long)b).longValue())) < 0L | (aa ^ (result = aa - bb)) >= 0L) {
                    return result;
                }
                BigInteger rr = BigInteger.valueOf(bb);
                return rr.add(BigInteger.valueOf(aa));
            }
            if (claszB == Double.class) {
                return (double)a.intValue() - (Double)b;
            }
            if (claszB == Float.class) {
                return (double)a.intValue() - (double)((Float)b).floatValue();
            }
            if (claszB == BigInteger.class) {
                return BigInteger.valueOf(a.intValue()).subtract((BigInteger)b);
            }
            if (claszB == BigDecimal.class) {
                return BigDecimal.valueOf(a.intValue()).subtract((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Add
    implements Operator<Integer, Number, Number> {
        @Override
        public Number op(Integer a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB == Integer.class || claszB == Short.class || claszB == Byte.class) {
                long result = (long)a.intValue() + (long)b.intValue();
                if (result == (long)((int)result)) {
                    return (int)result;
                }
                return result;
            }
            if (claszB == Long.class) {
                long result;
                long bb;
                long aa = a.intValue();
                if ((aa ^ (bb = ((Long)b).longValue())) < 0L | (aa ^ (result = aa + bb)) >= 0L) {
                    return result;
                }
                BigInteger rr = BigInteger.valueOf(bb);
                return rr.add(BigInteger.valueOf(aa));
            }
            if (claszB == Double.class) {
                return (Double)b + (double)a.intValue();
            }
            if (claszB == Float.class) {
                return (Double)b + (double)a.intValue();
            }
            if (claszB == BigInteger.class) {
                return ((BigInteger)b).add(BigInteger.valueOf(a.intValue()));
            }
            if (claszB == BigDecimal.class) {
                return ((BigDecimal)b).add(BigDecimal.valueOf(a.intValue()), (MathContext)MATH_CONTEXT.get());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }
}

