/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.instr;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.instr.LODX;
import org.spf4j.zel.instr.LValRef;
import org.spf4j.zel.vm.AssignableValue;
import org.spf4j.zel.vm.ExecutionContext;
import org.spf4j.zel.vm.ZExecutionException;

@SuppressFBWarnings(value={"CD_CIRCULAR_DEPENDENCY"})
public final class LODAX
extends Instruction
implements LValRef {
    private static final long serialVersionUID = 1257172216541960034L;
    private final String symbol;

    public LODAX(String symbol) {
        this.symbol = symbol;
    }

    public static void writeTo(String symbol, ExecutionContext context, Object what) throws ZExecutionException {
        Integer addr = context.code.getLocalSymbolTable().get(symbol);
        if (addr == null) {
            addr = context.code.getGlobalSymbolTable().get(symbol);
            if (addr == null) {
                throw new ZExecutionException("unalocated symbol encountered " + symbol);
            }
            context.globalMem[addr.intValue()] = what;
        } else {
            context.mem[addr.intValue()] = what;
        }
    }

    @Override
    public int execute(final ExecutionContext context) {
        context.push(new AssignableValue(){

            @Override
            public void assign(Object object) throws ZExecutionException {
                LODAX.writeTo(LODAX.this.symbol, context, object);
            }

            @Override
            public Object get() throws ZExecutionException {
                return LODX.readFrom(LODAX.this.symbol, context);
            }
        });
        return 1;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.symbol};
    }
}

