/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.Either;
import org.spf4j.base.Throwables;
import org.spf4j.concurrent.FutureBean;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.operators.Operator;
import org.spf4j.zel.vm.Program;
import org.spf4j.zel.vm.ResultCache;
import org.spf4j.zel.vm.SimpleResultCache;
import org.spf4j.zel.vm.SimpleStack;
import org.spf4j.zel.vm.SuspendedException;
import org.spf4j.zel.vm.VMExecutor;
import org.spf4j.zel.vm.VMFuture;
import org.spf4j.zel.vm.ZExecutionException;
import org.spf4j.zel.vm.ZelFrame;

@ParametersAreNonnullByDefault
public final class ExecutionContext {
    private static final long serialVersionUID = 1L;
    public MathContext mathContext;
    public final VMExecutor execService;
    public final ResultCache resultCache;
    public final Object[] mem;
    public final Object[] globalMem;
    public final Program code;
    public int ip;
    public boolean terminated;
    private final SimpleStack<Object> stack;
    public final transient InputStream in;
    public final transient PrintStream out;
    public final transient PrintStream err;
    List<VMFuture<Object>> suspendedAt;
    private final boolean isChildContext;
    private final Object[] tuple = new Object[2];

    public void suspend(VMFuture<Object> future) throws SuspendedException {
        this.suspendedAt = Arrays.asList(future);
        throw SuspendedException.INSTANCE;
    }

    public void suspend(List<VMFuture<Object>> futures) throws SuspendedException {
        this.suspendedAt = futures;
        throw SuspendedException.INSTANCE;
    }

    private ExecutionContext(ExecutionContext parent, @Nullable VMExecutor service, Program program) {
        this.in = parent.in;
        this.out = parent.out;
        this.err = parent.err;
        this.mem = new Object[program.getLocalMemSize()];
        this.globalMem = parent.globalMem;
        this.execService = service;
        this.stack = new SimpleStack(8);
        this.code = program;
        this.resultCache = parent.resultCache;
        this.ip = 0;
        this.isChildContext = true;
    }

    ExecutionContext(Program program, Object[] globalMem, @Nullable InputStream in, @Nullable PrintStream out, @Nullable PrintStream err, @Nullable VMExecutor execService) {
        this(program, globalMem, program.hasDeterministicFunctions() ? new SimpleResultCache() : null, in, out, err, execService);
    }

    ExecutionContext(Program program, Object[] globalMem, @Nullable ResultCache resultCache, @Nullable InputStream in, @Nullable PrintStream out, @Nullable PrintStream err, @Nullable VMExecutor execService) {
        this.code = program;
        this.in = in;
        this.out = out;
        this.err = err;
        this.execService = execService;
        this.stack = new SimpleStack(8);
        this.ip = 0;
        this.mem = new Object[program.getLocalMemSize()];
        this.globalMem = globalMem;
        this.resultCache = resultCache;
        this.isChildContext = false;
    }

    public VMExecutor.Suspendable<Object> getCallable() {
        return new VMExecutor.Suspendable<Object>(){

            @Override
            public Object call() throws ExecutionException, InterruptedException, SuspendedException {
                ExecutionContext.this.suspendedAt = null;
                if (ExecutionContext.this.mathContext != null) {
                    Operator.MATH_CONTEXT.set(ExecutionContext.this.mathContext);
                }
                Instruction[] instructions = ExecutionContext.this.code.getInstructions();
                try {
                    while (!ExecutionContext.this.terminated) {
                        Instruction icode = instructions[ExecutionContext.this.ip];
                        ExecutionContext.this.ip += icode.execute(ExecutionContext.this);
                    }
                    if (!ExecutionContext.this.isStackEmpty()) {
                        Object result = ExecutionContext.this.popSyncStackVal();
                        ExecutionContext.this.syncStackVals();
                        return result;
                    }
                    return null;
                }
                catch (InterruptedException | SuspendedException e) {
                    throw e;
                }
                catch (ZExecutionException e) {
                    e.addZelFrame(new ZelFrame(ExecutionContext.this.code.getName(), ExecutionContext.this.code.getSource(), ExecutionContext.this.code.getDebug()[ExecutionContext.this.ip].getRow()));
                    throw e;
                }
            }

            @Override
            public List<VMFuture<Object>> getSuspendedAt() {
                return ExecutionContext.this.suspendedAt;
            }
        };
    }

    public Object popSyncStackVal() throws SuspendedException, ExecutionException {
        Object result = this.stack.peek();
        if (result instanceof VMFuture) {
            VMFuture resFut = (VMFuture)result;
            Either resultStore = resFut.getResultStore();
            if (resultStore != null) {
                this.stack.remove();
                return FutureBean.processResult(resultStore);
            }
            this.suspend(resFut);
            throw new IllegalThreadStateException();
        }
        this.stack.remove();
        return result;
    }

    public void syncStackVal() throws SuspendedException, ExecutionException {
        Object result = this.stack.peek();
        if (result instanceof VMFuture) {
            VMFuture resFut = (VMFuture)result;
            Either resultStore = resFut.getResultStore();
            if (resultStore == null) {
                this.suspend(resFut);
                throw new IllegalThreadStateException();
            }
            this.stack.replaceFromTop(0, FutureBean.processResult(resultStore));
        }
    }

    public void syncStackVals() throws SuspendedException, ExecutionException {
        for (int i = 0; i < this.stack.size(); ++i) {
            Object result = this.stack.peekFromTop(i);
            if (!(result instanceof VMFuture)) continue;
            VMFuture resFut = (VMFuture)result;
            Either resultStore = resFut.getResultStore();
            if (resultStore == null) {
                this.suspend(resFut);
                throw new IllegalThreadStateException();
            }
            this.stack.replaceFromTop(i, FutureBean.processResult(resultStore));
        }
    }

    public Object[] popStackVals(int nvals) {
        return this.stack.pop(nvals);
    }

    public Object popStackVal() {
        return this.stack.pop();
    }

    public int getNrStackVals() {
        return this.stack.size();
    }

    public Object[] popSyncStackVals(int nvals) throws SuspendedException, ExecutionException {
        if (nvals == 0) {
            return org.spf4j.base.Arrays.EMPTY_OBJ_ARRAY;
        }
        Object[] result = new Object[nvals];
        this.popSyncStackVals(result);
        return result;
    }

    @SuppressFBWarnings
    public Object[] tuple() {
        return this.tuple;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void popSyncStackVals(Object[] vals) throws SuspendedException, ExecutionException {
        int l = vals.length;
        int i = 0;
        int j = l - 1;
        while (true) {
            if (i >= l) {
                this.stack.removeFromTop(l);
                return;
            }
            Object obj = this.stack.peekFromTop(i);
            if (obj instanceof VMFuture) {
                VMFuture resFut = (VMFuture)obj;
                Either resultStore = resFut.getResultStore();
                if (resultStore == null) {
                    this.suspend(resFut);
                    throw new IllegalStateException();
                }
                Object processResult = FutureBean.processResult(resultStore);
                this.stack.replaceFromTop(i, processResult);
                vals[j] = processResult;
            } else {
                vals[j] = obj;
            }
            ++i;
            --j;
        }
    }

    public Object popFirstAvail(int nr) throws SuspendedException {
        int nrErrors = 0;
        ExecutionException e = null;
        ArrayList<VMFuture> futures = null;
        for (int i = 0; i < nr; ++i) {
            Object obj = this.stack.peekFromTop(i);
            if (obj instanceof VMFuture) {
                VMFuture resFut = (VMFuture)obj;
                Either resultStore = resFut.getResultStore();
                if (resultStore != null) {
                    if (resultStore.isLeft()) {
                        this.stack.removeFromTop(nr);
                        return resultStore.getLeft();
                    }
                    ++nrErrors;
                    if (e == null) {
                        e = (ExecutionException)resultStore.getRight();
                        continue;
                    }
                    e = (ExecutionException)Throwables.chain((Throwable)((Throwable)resultStore.getRight()), (Throwable)e);
                    continue;
                }
                if (futures == null) {
                    futures = new ArrayList<VMFuture>(nr);
                }
                futures.add(resFut);
                continue;
            }
            this.stack.removeFromTop(nr);
            return obj;
        }
        if (nrErrors == nr) {
            if (e == null) {
                throw new IllegalStateException();
            }
            throw new RuntimeException(e);
        }
        if (futures == null || futures.isEmpty()) {
            throw new IllegalStateException();
        }
        this.suspend((List<VMFuture<Object>>)futures);
        throw new IllegalStateException();
    }

    public Object pop() {
        return this.stack.pop();
    }

    public void push(@Nullable Object obj) {
        this.stack.push(obj);
    }

    public void pushAll(Object[] objects) {
        this.stack.pushAll((Object[])objects);
    }

    public boolean isStackEmpty() {
        return this.stack.isEmpty();
    }

    public Object peek() {
        return this.stack.peek();
    }

    public Object peekFromTop(int n) {
        return this.stack.peekFromTop(n);
    }

    public Object peekElemAfter(Object elem) {
        return this.stack.peekElemAfter(elem);
    }

    public Object getFromPtr(int ptr) {
        return this.stack.getFromPtr(ptr);
    }

    public ExecutionContext getSubProgramContext(Program program, Object[] parameters) {
        ExecutionContext ec = program.getExecType() == Program.ExecutionType.SYNC ? new ExecutionContext(this, null, program) : new ExecutionContext(this, this.execService, program);
        System.arraycopy(parameters, 0, ec.mem, 0, parameters.length);
        return ec;
    }

    public ExecutionContext getSyncSubProgramContext(Program program, Object[] parameters) {
        ExecutionContext ec = new ExecutionContext(this, null, program);
        System.arraycopy(parameters, 0, ec.mem, 0, parameters.length);
        return ec;
    }

    public String toString() {
        return "ExecutionContext{execService=" + this.execService + ",\nresultCache=" + this.resultCache + ",\nmemory=" + Arrays.toString(this.mem) + ",\nlocalSymbolTable=" + this.code.getLocalSymbolTable() + ",\nglobalMem=" + Arrays.toString(this.globalMem) + ",\nglobalSymbolTable=" + this.code.getGlobalSymbolTable() + ",\ncode=" + this.code + ", ip=" + this.ip + ", terminated=" + this.terminated + ",\nstack=" + this.stack + ", in=" + this.in + ",\nout=" + this.out + ", err=" + this.err + '}';
    }

    public boolean isChildContext() {
        return this.isChildContext;
    }
}

