/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.operators;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.spf4j.zel.operators.Operator;

public final class BigDecimalOperators {
    private BigDecimalOperators() {
    }

    public static final class Pow
    implements Operator<BigDecimal, Number, Number> {
        @Override
        public Number op(BigDecimal a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a.pow(b.intValue(), (MathContext)MATH_CONTEXT.get());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Mod
    implements Operator<BigDecimal, Number, Number> {
        @Override
        public Number op(BigDecimal a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a.toBigInteger().mod(BigInteger.valueOf(b.intValue()));
            }
            if (claszB.equals(Long.class)) {
                return a.toBigInteger().mod(BigInteger.valueOf(b.longValue()));
            }
            if (claszB.equals(Double.class)) {
                return a.toBigInteger().mod(new BigDecimal(b.doubleValue()).toBigInteger());
            }
            if (claszB.equals(BigInteger.class)) {
                return a.toBigInteger().mod((BigInteger)b);
            }
            if (claszB.equals(BigDecimal.class)) {
                return a.toBigInteger().mod(((BigDecimal)b).toBigInteger());
            }
            if (claszB.equals(Float.class)) {
                return a.toBigInteger().mod(new BigDecimal(b.doubleValue()).toBigInteger());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Div
    implements Operator<BigDecimal, Number, Number> {
        @Override
        public Number op(BigDecimal a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a.divide(new BigDecimal(b.intValue()), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(Long.class)) {
                return a.divide(new BigDecimal(b.longValue()), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(Double.class)) {
                return a.divide(new BigDecimal(b.doubleValue()), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(BigInteger.class)) {
                return a.divide(new BigDecimal((BigInteger)b), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(BigDecimal.class)) {
                return a.divide((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(Float.class)) {
                return a.divide(new BigDecimal(b.doubleValue()), (MathContext)MATH_CONTEXT.get());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Mul
    implements Operator<BigDecimal, Number, Number> {
        @Override
        public Number op(BigDecimal a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a.multiply(new BigDecimal(b.intValue()), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(Long.class)) {
                return a.multiply(new BigDecimal(b.longValue()), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(Double.class)) {
                return a.multiply(new BigDecimal(b.doubleValue()), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(BigInteger.class)) {
                return a.multiply(new BigDecimal((BigInteger)b), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(BigDecimal.class)) {
                return a.multiply((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(Double.class)) {
                return a.multiply(new BigDecimal(b.doubleValue()), (MathContext)MATH_CONTEXT.get());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Sub
    implements Operator<BigDecimal, Number, Number> {
        @Override
        public Number op(BigDecimal a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a.subtract(new BigDecimal(b.intValue()), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(Long.class)) {
                return a.subtract(new BigDecimal(b.longValue()), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(Double.class)) {
                return a.subtract(new BigDecimal(b.doubleValue()), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(BigInteger.class)) {
                return a.subtract(new BigDecimal((BigInteger)b), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(BigDecimal.class)) {
                return a.subtract((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(Float.class)) {
                return a.subtract(new BigDecimal(b.floatValue()), (MathContext)MATH_CONTEXT.get());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Add
    implements Operator<BigDecimal, Number, Number> {
        @Override
        public Number op(BigDecimal a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a.add(new BigDecimal(b.intValue()), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(Long.class)) {
                return a.add(new BigDecimal(b.longValue()), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(Double.class)) {
                return a.add(new BigDecimal(b.doubleValue()), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(BigInteger.class)) {
                return a.add(new BigDecimal((BigInteger)b), (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(BigDecimal.class)) {
                return a.add((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
            }
            if (claszB.equals(Float.class)) {
                return a.add(new BigDecimal(b.floatValue()), (MathContext)MATH_CONTEXT.get());
            }
            throw new IllegalArgumentException(b.toString());
        }
    }
}

