/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.operators;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.spf4j.zel.operators.Operator;

public final class DoubleOperators {
    private DoubleOperators() {
    }

    public static final class Pow
    implements Operator<Double, Number, Number> {
        @Override
        public Number op(Double a, Number b) {
            return Math.pow(a, b.doubleValue());
        }
    }

    public static final class Mod
    implements Operator<Double, Number, Number> {
        @Override
        public Number op(Double a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a.longValue() % (long)b.intValue();
            }
            if (claszB.equals(Long.class)) {
                return a.longValue() % b.longValue();
            }
            if (claszB.equals(Double.class)) {
                return a % (double)b.longValue();
            }
            if (claszB.equals(BigInteger.class)) {
                return BigInteger.valueOf(a.longValue()).mod((BigInteger)b).intValue();
            }
            if (claszB.equals(BigDecimal.class)) {
                return BigInteger.valueOf(a.longValue()).mod(((BigDecimal)b).toBigInteger()).intValue();
            }
            if (claszB.equals(Float.class)) {
                return a % (double)b.longValue();
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Div
    implements Operator<Double, Number, Number> {
        @Override
        public Number op(Double a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a / (double)b.intValue();
            }
            if (claszB.equals(Long.class)) {
                return a / (double)b.longValue();
            }
            if (claszB.equals(Double.class)) {
                return a / (Double)b;
            }
            if (claszB.equals(BigInteger.class)) {
                return a / b.doubleValue();
            }
            if (claszB.equals(BigDecimal.class)) {
                return a / b.doubleValue();
            }
            if (claszB.equals(Float.class)) {
                return a / (double)b.floatValue();
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Mul
    implements Operator<Double, Number, Number> {
        @Override
        public Number op(Double a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a * (double)b.intValue();
            }
            if (claszB.equals(Long.class)) {
                return a * (double)b.longValue();
            }
            if (claszB.equals(Double.class)) {
                return a * (Double)b;
            }
            if (claszB.equals(BigInteger.class)) {
                return a * b.doubleValue();
            }
            if (claszB.equals(BigDecimal.class)) {
                return a * b.doubleValue();
            }
            if (claszB.equals(Double.class)) {
                return a * (double)b.floatValue();
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Sub
    implements Operator<Double, Number, Number> {
        @Override
        public Number op(Double a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a - (double)b.intValue();
            }
            if (claszB.equals(Long.class)) {
                return a - (double)b.longValue();
            }
            if (claszB.equals(Double.class)) {
                return a - b.doubleValue();
            }
            if (claszB.equals(BigInteger.class)) {
                return a - b.doubleValue();
            }
            if (claszB.equals(BigDecimal.class)) {
                return a - b.doubleValue();
            }
            if (claszB.equals(Float.class)) {
                return a - (double)b.floatValue();
            }
            throw new IllegalArgumentException(b.toString());
        }
    }

    public static final class Add
    implements Operator<Double, Number, Number> {
        @Override
        public Number op(Double a, Number b) {
            Class<?> claszB = b.getClass();
            if (claszB.equals(Integer.class) || claszB.equals(Short.class) || claszB.equals(Byte.class) || claszB.equals(Character.class)) {
                return a + (double)b.intValue();
            }
            if (claszB.equals(Long.class)) {
                return a + (double)b.longValue();
            }
            if (claszB.equals(Double.class)) {
                return a + b.doubleValue();
            }
            if (claszB.equals(BigInteger.class)) {
                return a + b.doubleValue();
            }
            if (claszB.equals(BigDecimal.class)) {
                return a + b.doubleValue();
            }
            if (claszB.equals(Float.class)) {
                return a + (double)b.floatValue();
            }
            throw new IllegalArgumentException(b.toString());
        }
    }
}

