/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.operators;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.spf4j.zel.operators.AbstractOps;
import org.spf4j.zel.operators.Operator;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
public final class BigIntegerOperators {
    private BigIntegerOperators() {
    }

    public static final class Pow
    extends AbstractOps<BigInteger> {
        public Pow() {
            Operator<BigInteger, Number, Number> isbc = new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return a.pow(b.intValue());
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    if (((Long)b).compareTo((Long)Integer.MAX_VALUE) > 0) {
                        return Math.pow(a.doubleValue(), ((Long)b).longValue());
                    }
                    return a.pow(b.intValue());
                }
            });
            Operator<BigInteger, Number, Number> dfOp = new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return Math.pow(a.doubleValue(), b.doubleValue());
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return Math.pow(a.doubleValue(), b.doubleValue());
                }
            });
            this.operations.put(BigDecimal.class, new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return Math.pow(a.doubleValue(), b.doubleValue());
                }
            });
        }
    }

    public static final class Mod
    extends AbstractOps<BigInteger> {
        public Mod() {
            Operator<BigInteger, Number, Number> isbc = new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return a.mod(BigInteger.valueOf(b.longValue()));
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, isbc);
            Operator<BigInteger, Number, Number> dfOp = new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return a.mod(BigInteger.valueOf(b.longValue()));
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return a.mod((BigInteger)b).intValue();
                }
            });
            this.operations.put(BigDecimal.class, new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return a.mod(((BigDecimal)b).toBigInteger()).intValue();
                }
            });
        }
    }

    public static final class Div
    extends AbstractOps<BigInteger> {
        public Div() {
            Operator<BigInteger, Number, Number> isbc = new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return a.divide(BigInteger.valueOf(b.longValue()));
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, isbc);
            Operator<BigInteger, Number, Number> dfOp = new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return a.doubleValue() / b.doubleValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return a.divide((BigInteger)b).intValue();
                }
            });
            this.operations.put(BigDecimal.class, new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return new BigDecimal(a).divide((BigDecimal)b, (MathContext)MATH_CONTEXT.get()).intValue();
                }
            });
        }
    }

    public static final class Mul
    extends AbstractOps<BigInteger> {
        public Mul() {
            Operator<BigInteger, Number, Number> isbc = new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return a.multiply(BigInteger.valueOf(b.longValue()));
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, isbc);
            Operator<BigInteger, Number, Number> dfOp = new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return a.doubleValue() * b.doubleValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return a.multiply((BigInteger)b);
                }
            });
            this.operations.put(BigDecimal.class, new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return new BigDecimal(a).multiply((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
                }
            });
        }
    }

    public static final class Sub
    extends AbstractOps<BigInteger> {
        public Sub() {
            Operator<BigInteger, Number, Number> isbc = new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return a.subtract(BigInteger.valueOf(b.longValue()));
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, isbc);
            Operator<BigInteger, Number, Number> dfOp = new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return a.doubleValue() - b.doubleValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return a.subtract((BigInteger)b);
                }
            });
            this.operations.put(BigDecimal.class, new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return new BigDecimal(a).subtract((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
                }
            });
        }
    }

    public static final class Add
    extends AbstractOps<BigInteger> {
        public Add() {
            Operator<BigInteger, Number, Number> isbc = new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return a.add(BigInteger.valueOf(b.longValue()));
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, isbc);
            Operator<BigInteger, Number, Number> dfOp = new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return b.doubleValue() + a.doubleValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return ((BigInteger)b).add(a);
                }
            });
            this.operations.put(BigDecimal.class, new Operator<BigInteger, Number, Number>(){

                @Override
                public Number op(BigInteger a, Number b) {
                    return ((BigDecimal)b).add(new BigDecimal(a), (MathContext)MATH_CONTEXT.get());
                }
            });
        }
    }
}

