/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.operators;

import com.google.common.math.LongMath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.spf4j.zel.operators.AbstractOps;
import org.spf4j.zel.operators.Operator;

@SuppressFBWarnings(value={"NS_DANGEROUS_NON_SHORT_CIRCUIT", "NS_NON_SHORT_CIRCUIT", "SIC_INNER_SHOULD_BE_STATIC_ANON"})
public final class LongOperators {
    private LongOperators() {
    }

    private static Number powLongInt(Long a, Number b) {
        long result;
        try {
            result = LongMath.checkedPow((long)a, (int)b.intValue());
        }
        catch (ArithmeticException e) {
            return BigInteger.valueOf(a).pow(b.intValue());
        }
        return result;
    }

    public static final class Pow
    extends AbstractOps<Long> {
        public Pow() {
            Operator<Long, Number, Number> isbc = new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return LongOperators.powLongInt(a, b);
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    if (((Long)b).compareTo((Long)Integer.MAX_VALUE) > 0) {
                        return Math.pow(a.longValue(), ((Long)b).longValue());
                    }
                    return LongOperators.powLongInt(a, b.intValue());
                }
            });
            Operator<Long, Number, Number> dfOp = new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return Math.pow(a.longValue(), b.doubleValue());
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return BigInteger.valueOf(a).pow(b.intValue());
                }
            });
            this.operations.put(BigDecimal.class, new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return BigDecimal.valueOf(a).pow(b.intValue());
                }
            });
        }
    }

    public static final class Mod
    extends AbstractOps<Long> {
        public Mod() {
            Operator<Long, Number, Number> isbc = new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return a % b.longValue();
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, isbc);
            Operator<Long, Number, Number> dfOp = new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return a % b.longValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return BigInteger.valueOf(a).mod((BigInteger)b).longValue();
                }
            });
            this.operations.put(BigDecimal.class, new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return BigInteger.valueOf(a).mod(((BigDecimal)b).toBigInteger()).longValue();
                }
            });
        }
    }

    public static final class Div
    extends AbstractOps<Long> {
        public Div() {
            Operator<Long, Number, Number> isbc = new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return a / b.longValue();
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, isbc);
            Operator<Long, Number, Number> dfOp = new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return (double)a.longValue() / b.doubleValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return BigInteger.valueOf(a).divide((BigInteger)b).intValue();
                }
            });
            this.operations.put(BigDecimal.class, new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return BigDecimal.valueOf(a).divide((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
                }
            });
        }
    }

    public static final class Mul
    extends AbstractOps<Long> {
        public Mul() {
            Operator<Long, Number, Number> isbc = new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long pa, Number b) {
                    long a = pa;
                    long bb = b.longValue();
                    int leadingZeros = Long.numberOfLeadingZeros(a) + Long.numberOfLeadingZeros(a ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(bb) + Long.numberOfLeadingZeros(bb ^ 0xFFFFFFFFFFFFFFFFL);
                    if (leadingZeros > 65) {
                        return a * bb;
                    }
                    if (leadingZeros < 64) {
                        return BigInteger.valueOf(a).multiply(BigInteger.valueOf(bb));
                    }
                    if (!(a >= 0L | bb != Long.MIN_VALUE)) {
                        return BigInteger.valueOf(a).multiply(BigInteger.valueOf(bb));
                    }
                    long result = a * bb;
                    if (a != 0L && result / a != bb) {
                        return BigInteger.valueOf(a).multiply(BigInteger.valueOf(bb));
                    }
                    return result;
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, isbc);
            Operator<Long, Number, Number> dfOp = new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return (double)a.longValue() * b.doubleValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return BigInteger.valueOf(a).multiply((BigInteger)b);
                }
            });
            this.operations.put(BigDecimal.class, new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return BigDecimal.valueOf(a).multiply((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
                }
            });
        }
    }

    public static final class Sub
    extends AbstractOps<Long> {
        public Sub() {
            Operator<Long, Number, Number> isbc = new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long pa, Number b) {
                    long result;
                    long bb;
                    long a = pa;
                    if ((a ^ (bb = b.longValue())) < 0L | (a ^ (result = a - bb)) >= 0L) {
                        return result;
                    }
                    return BigInteger.valueOf(a).subtract(BigInteger.valueOf(bb));
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, isbc);
            Operator<Long, Number, Number> dfOp = new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return (double)a.longValue() - b.doubleValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return BigInteger.valueOf(a).subtract((BigInteger)b);
                }
            });
            this.operations.put(BigDecimal.class, new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return BigDecimal.valueOf(a).subtract((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
                }
            });
        }
    }

    public static final class Add
    extends AbstractOps<Long> {
        public Add() {
            Operator<Long, Number, Number> isbc = new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long pa, Number b) {
                    long result;
                    long bb;
                    long a = pa;
                    if ((a ^ (bb = b.longValue())) < 0L | (a ^ (result = a + bb)) >= 0L) {
                        return result;
                    }
                    return BigInteger.valueOf(a).add(BigInteger.valueOf(bb));
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, isbc);
            Operator<Long, Number, Number> dfOp = new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return b.doubleValue() + (double)a.longValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return ((BigInteger)b).add(BigInteger.valueOf(a));
                }
            });
            this.operations.put(BigDecimal.class, new Operator<Long, Number, Number>(){

                @Override
                public Number op(Long a, Number b) {
                    return ((BigDecimal)b).add(BigDecimal.valueOf(a), (MathContext)MATH_CONTEXT.get());
                }
            });
        }
    }
}

