/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.operators;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.spf4j.zel.operators.BigDecimalOperators;
import org.spf4j.zel.operators.BigIntegerOperators;
import org.spf4j.zel.operators.DoubleOperators;
import org.spf4j.zel.operators.IntegerOperators;
import org.spf4j.zel.operators.LongOperators;
import org.spf4j.zel.operators.Operator;

public final class Operators {
    private static final Class<?>[] IMPLS = new Class[]{IntegerOperators.class, DoubleOperators.class, LongOperators.class, BigIntegerOperators.class, BigDecimalOperators.class};
    private static final Map<Class<?>, Operator<Object, Object, Object>>[] OPS;

    private Operators() {
    }

    public static Object apply(Operator.Enum op, Object a, Object b) {
        return OPS[op.ordinal()].get(a.getClass()).op(a, b);
    }

    static {
        Operator.Enum[] operators = Operator.Enum.values();
        OPS = new Map[operators.length];
        for (int i = 0; i < OPS.length; ++i) {
            Operators.OPS[i] = new HashMap();
        }
        HashSet<String> ops = new HashSet<String>(operators.length);
        for (Operator.Enum enum_ : operators) {
            ops.add(enum_.toString());
        }
        for (Class<?> clazz : IMPLS) {
            Class<?>[] subClasses;
            for (Class<?> subClasz : subClasses = clazz.getClasses()) {
                String claszName = subClasz.getSimpleName();
                if (!ops.contains(claszName)) continue;
                try {
                    Type type = subClasz.getGenericSuperclass();
                    if (!(type instanceof ParameterizedType)) {
                        throw new RuntimeException("Operators class improperly implemented " + subClasz);
                    }
                    Class leftOClasz = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                    Operator op = (Operator)subClasz.newInstance();
                    Operator.Enum ope = Operator.Enum.valueOf(claszName);
                    OPS[ope.ordinal()].put(leftOClasz, op);
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

