/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.instr;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.avro.generic.GenericRecord;
import org.spf4j.base.Arrays;
import org.spf4j.reflect.CachingTypeMapWrapper;
import org.spf4j.reflect.GraphTypeMap;
import org.spf4j.reflect.TypeMap;
import org.spf4j.zel.instr.DEREF;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.vm.ExecutionContext;
import org.spf4j.zel.vm.SuspendedException;

public final class CDEREFX
extends Instruction {
    private static final long serialVersionUID = 1L;
    private static final CachingTypeMapWrapper<DEREF.ReferenceHandler> TYPE_HANDLER = new CachingTypeMapWrapper((TypeMap)new GraphTypeMap());
    private final Object ref;

    public CDEREFX(Object ref) {
        this.ref = ref;
    }

    @Override
    public int execute(ExecutionContext context) throws SuspendedException, ExecutionException {
        Object relativeTo = context.popSyncStackVal();
        if (relativeTo != null) {
            CDEREFX.pushDeref(relativeTo, this.ref, context);
        } else {
            context.pushNull();
        }
        return 1;
    }

    private static void pushDeref(Object relativeTo, Object ref, ExecutionContext context) {
        DEREF.ReferenceHandler rh = (DEREF.ReferenceHandler)TYPE_HANDLER.get(relativeTo.getClass());
        rh.pushDeref(relativeTo, ref, context);
    }

    @Override
    public Object[] getParameters() {
        return Arrays.EMPTY_OBJ_ARRAY;
    }

    static {
        TYPE_HANDLER.safePut(Map.class, (relativeTo, ref, context) -> context.push(((Map)relativeTo).get(ref))).safePut(GenericRecord.class, (relativeTo, ref, context) -> {
            GenericRecord gr = (GenericRecord)relativeTo;
            String fName = ref.toString();
            if (gr.getSchema().getField(fName) != null) {
                context.push(gr.get(fName));
            } else {
                context.pushNull();
            }
        }).safePut(Object.class, (relativeTo, ref, context) -> context.push(context.newJavaCall(relativeTo, ref.toString()))).safePut(Object[].class, (relativeTo, ref, context) -> {
            if ("length".equals(ref)) {
                context.push(((Object[])relativeTo).length);
            } else {
                context.push(((Object[])relativeTo)[((Number)ref).intValue()]);
            }
        }).safePut(int[].class, (relativeTo, ref, context) -> {
            if ("length".equals(ref)) {
                context.push(((int[])relativeTo).length);
            } else {
                context.push(((int[])relativeTo)[((Number)ref).intValue()]);
            }
        }).safePut(byte[].class, (relativeTo, ref, context) -> {
            if ("length".equals(ref)) {
                context.push(((byte[])relativeTo).length);
            } else {
                context.push(((byte[])relativeTo)[((Number)ref).intValue()]);
            }
        }).safePut(char[].class, (relativeTo, ref, context) -> {
            if ("length".equals(ref)) {
                context.push(((char[])relativeTo).length);
            } else {
                context.push(Character.valueOf(((char[])relativeTo)[((Number)ref).intValue()]));
            }
        }).safePut(long[].class, (relativeTo, ref, context) -> {
            if ("length".equals(ref)) {
                context.push(((long[])relativeTo).length);
            } else {
                context.push(((long[])relativeTo)[((Number)ref).intValue()]);
            }
        }).safePut(short[].class, (relativeTo, ref, context) -> {
            if ("length".equals(ref)) {
                context.push(((short[])relativeTo).length);
            } else {
                context.push(((short[])relativeTo)[((Number)ref).intValue()]);
            }
        }).safePut(List.class, (relativeTo, ref, context) -> {
            if ("length".equals(ref)) {
                context.push(((List)relativeTo).size());
            } else {
                context.push(((List)relativeTo).get(((Number)ref).intValue()));
            }
        });
    }
}

