/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.instr;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.instr.SyncAsyncCallable;
import org.spf4j.zel.vm.ExecutionContext;
import org.spf4j.zel.vm.Method;
import org.spf4j.zel.vm.Program;
import org.spf4j.zel.vm.SuspendedException;
import org.spf4j.zel.vm.ZExecutionException;

public final class CALL
extends Instruction {
    private static final long serialVersionUID = 759722625722456554L;
    private final int nrParameters;

    public CALL(int nrParameters) {
        this.nrParameters = nrParameters;
    }

    @Override
    @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
    public int execute(ExecutionContext context) throws ExecutionException, InterruptedException, SuspendedException {
        Object function = context.peekFromTop(this.nrParameters);
        if (function instanceof Program) {
            Object obj;
            Program p = (Program)function;
            switch (p.getType()) {
                case DETERMINISTIC: {
                    ExecutionContext nctx = context.getSubProgramContext(p, this.nrParameters);
                    context.pop();
                    List<Object> params = CALL.getParameters(nctx, this.nrParameters);
                    obj = context.getResultCache().getResult(p, params, new SyncAsyncCallable(nctx));
                    break;
                }
                case NONDETERMINISTIC: {
                    ExecutionContext nctx = context.getSubProgramContext(p, this.nrParameters);
                    context.pop();
                    obj = nctx.executeSyncOrAsync();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(p.getType().toString());
                }
            }
            context.push(obj);
        } else if (function instanceof Method) {
            Object[] parameters = context.popSyncStackVals(this.nrParameters);
            context.pop();
            try {
                context.push(((Method)function).invoke(context, parameters));
            }
            catch (RuntimeException ex) {
                throw new ZExecutionException("cannot invoke " + function, ex);
            }
        } else {
            throw new ZExecutionException("cannot invoke " + function);
        }
        return 1;
    }

    public static List<Object> getParameters(ExecutionContext nctx, int nrParameters) {
        ArrayList<Object> params = new ArrayList<Object>(nrParameters);
        for (int i = 0; i < nrParameters; ++i) {
            params.add(nctx.localPeek(i));
        }
        return params;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.nrParameters};
    }
}

