/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.operators;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.spf4j.zel.operators.AbstractOps;
import org.spf4j.zel.operators.Operator;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
public final class DoubleOperators {
    private DoubleOperators() {
    }

    public static final class Pow
    extends AbstractOps<Double> {
        @Override
        public Number op(Double a, Number b) {
            return Math.pow(a, b.doubleValue());
        }
    }

    public static final class Mod
    extends AbstractOps<Double> {
    }

    public static final class Div
    extends AbstractOps<Double> {
        public Div() {
            Operator<Double, Number, Number> isbc = new Operator<Double, Number, Number>(){

                @Override
                public Number op(Double a, Number b) {
                    return a / (double)b.intValue();
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<Double, Number, Number>(){

                @Override
                public Number op(Double a, Number b) {
                    return a / (double)b.longValue();
                }
            });
            Operator<Double, Number, Number> dfOp = new Operator<Double, Number, Number>(){

                @Override
                public Number op(Double a, Number b) {
                    return a / b.doubleValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, dfOp);
            this.operations.put(BigDecimal.class, dfOp);
        }
    }

    public static final class Mul
    extends AbstractOps<Double> {
        public Mul() {
            Operator<Double, Number, Number> isbc = new Operator<Double, Number, Number>(){

                @Override
                public Number op(Double a, Number b) {
                    return a * (double)b.intValue();
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<Double, Number, Number>(){

                @Override
                public Number op(Double a, Number b) {
                    return a * (double)b.longValue();
                }
            });
            Operator<Double, Number, Number> dfOp = new Operator<Double, Number, Number>(){

                @Override
                public Number op(Double a, Number b) {
                    return a * b.doubleValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, dfOp);
            this.operations.put(BigDecimal.class, dfOp);
        }
    }

    public static final class Sub
    extends AbstractOps<Double> {
        public Sub() {
            Operator<Double, Number, Number> isbc = new Operator<Double, Number, Number>(){

                @Override
                public Number op(Double a, Number b) {
                    return a - (double)b.intValue();
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<Double, Number, Number>(){

                @Override
                public Number op(Double a, Number b) {
                    return a - (double)b.longValue();
                }
            });
            Operator<Double, Number, Number> dfOp = new Operator<Double, Number, Number>(){

                @Override
                public Number op(Double a, Number b) {
                    return a - b.doubleValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, dfOp);
            this.operations.put(BigDecimal.class, dfOp);
        }
    }

    public static final class Add
    extends AbstractOps<Double> {
        public Add() {
            Operator<Double, Number, Number> isbc = new Operator<Double, Number, Number>(){

                @Override
                public Number op(Double a, Number b) {
                    return a + (double)b.intValue();
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<Double, Number, Number>(){

                @Override
                public Number op(Double a, Number b) {
                    return a + (double)b.longValue();
                }
            });
            Operator<Double, Number, Number> dfOp = new Operator<Double, Number, Number>(){

                @Override
                public Number op(Double a, Number b) {
                    return a + b.doubleValue();
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, dfOp);
            this.operations.put(BigDecimal.class, dfOp);
        }
    }
}

