/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import com.google.common.base.Function;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.spf4j.base.Pair;
import org.spf4j.zel.instr.CALLA;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.vm.CompileException;
import org.spf4j.zel.vm.MemoryBuilder;
import org.spf4j.zel.vm.ParsingContext;
import org.spf4j.zel.vm.Program;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public final class ProgramBuilder {
    private static final int DEFAULT_SIZE = 16;
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private Instruction[] instructions;
    private final List<ParsingContext.Location> debugInfo;
    private int instrNumber;
    private Program.Type type;
    private Program.ExecutionType execType;
    private final Interner<String> stringInterner;
    private final MemoryBuilder staticMemBuilder;

    public static int generateID() {
        return COUNTER.getAndIncrement();
    }

    public ProgramBuilder(MemoryBuilder staticMemBuilder) {
        this.staticMemBuilder = staticMemBuilder;
        this.instructions = new Instruction[16];
        this.instrNumber = 0;
        this.type = Program.Type.NONDETERMINISTIC;
        this.execType = null;
        this.stringInterner = Interners.newStrongInterner();
        this.debugInfo = new ArrayList<ParsingContext.Location>();
    }

    public void intern(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            Object obj = array[i];
            if (!(obj instanceof String)) continue;
            array[i] = this.stringInterner.intern((Object)((String)obj));
        }
    }

    public Program.Type getType() {
        return this.type;
    }

    public ProgramBuilder setType(Program.Type ptype) {
        this.type = ptype;
        return this;
    }

    public ProgramBuilder setExecType(Program.ExecutionType pexecType) {
        this.execType = pexecType;
        return this;
    }

    public ProgramBuilder add(Instruction object, ParsingContext.Location loc) {
        this.ensureCapacity(this.instrNumber + 1);
        this.instructions[this.instrNumber++] = object;
        this.debugInfo.add(loc);
        return this;
    }

    public boolean contains(Class<? extends Instruction> instr) {
        Boolean res = this.itterate(new Program.HasClass(instr));
        if (res == null) {
            return false;
        }
        return res;
    }

    public <T> T itterate(Function<Object, T> func) {
        for (int i = 0; i < this.instrNumber; ++i) {
            Instruction code = this.instructions[i];
            Object res = func.apply((Object)code);
            if (res != null) {
                return (T)res;
            }
            for (Object param : code.getParameters()) {
                res = func.apply(param);
                if (res != null) {
                    return (T)res;
                }
                if (param instanceof Program) {
                    res = ((Program)param).itterate(func);
                }
                if (res == null) continue;
                return (T)res;
            }
        }
        return null;
    }

    public ProgramBuilder set(int idx, Instruction object) {
        this.ensureCapacity(idx + 1);
        this.instructions[idx] = object;
        this.instrNumber = Math.max(idx + 1, this.instrNumber);
        return this;
    }

    public ProgramBuilder addAll(Instruction[] objects, List<ParsingContext.Location> debug) {
        this.ensureCapacity(this.instrNumber + objects.length);
        System.arraycopy(objects, 0, this.instructions, this.instrNumber, objects.length);
        this.instrNumber += objects.length;
        this.debugInfo.addAll(debug);
        return this;
    }

    public ProgramBuilder addAll(ProgramBuilder opb) {
        this.ensureCapacity(this.instrNumber + opb.instrNumber);
        System.arraycopy(opb.instructions, 0, this.instructions, this.instrNumber, opb.instrNumber);
        this.instrNumber += opb.instrNumber;
        this.debugInfo.addAll(opb.debugInfo);
        return this;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.instructions.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.instructions = Arrays.copyOf(this.instructions, newCapacity);
        }
    }

    public int size() {
        return this.instrNumber;
    }

    public Object[] toArray() {
        return Arrays.copyOf(this.instructions, this.instrNumber);
    }

    public boolean hasDeterministicFunctions() {
        Boolean hasDetFuncs = this.itterate(new HasDeterministicFunc());
        if (hasDetFuncs == null) {
            hasDetFuncs = Boolean.FALSE;
        }
        return hasDetFuncs;
    }

    public boolean hasAsyncCalls() {
        Boolean hasAsyncCalls = this.itterate(new HasAsyncFunc());
        if (hasAsyncCalls == null) {
            return false;
        }
        return hasAsyncCalls;
    }

    public Program toProgram(String name, String source, String[] parameterNames) throws CompileException {
        return this.toProgram(name, source, parameterNames, Collections.EMPTY_MAP);
    }

    public Program toProgram(String name, String source, String[] parameterNames, Map<String, Integer> localTable) throws CompileException {
        this.intern(this.instructions);
        this.intern(parameterNames);
        Pair<Object[], Map<String, Integer>> build = this.staticMemBuilder.build();
        boolean hasAsyncPrograms = false;
        for (Object obj : (Object[])build.getFirst()) {
            Program prog;
            if (!(obj instanceof Program) || (prog = (Program)obj).getExecType() != Program.ExecutionType.ASYNC) continue;
            hasAsyncPrograms = true;
            break;
        }
        return new Program(name, (Map)build.getSecond(), (Object[])build.getFirst(), localTable, this.instructions, this.debugInfo.toArray(new ParsingContext.Location[this.debugInfo.size()]), source, 0, this.instrNumber, this.type, hasAsyncPrograms || this.execType == Program.ExecutionType.ASYNC || this.hasAsyncCalls() ? (this.execType == null ? Program.ExecutionType.ASYNC : this.execType) : Program.ExecutionType.SYNC, this.hasDeterministicFunctions(), parameterNames);
    }

    public Program toProgram(String name, String source, List<String> parameterNames) throws CompileException {
        return this.toProgram(name, source, parameterNames.toArray(new String[parameterNames.size()]));
    }

    public String toString() {
        return "ProgramBuilder{instructions=" + Arrays.toString(this.instructions) + ", debugInfo=" + this.debugInfo + ", instrNumber=" + this.instrNumber + ", type=" + (Object)((Object)this.type) + ", execType=" + (Object)((Object)this.execType) + ", stringInterner=" + this.stringInterner + ", staticMemBuilder=" + this.staticMemBuilder + '}';
    }

    private static final class HasAsyncFunc
    implements Function<Object, Boolean> {
        private HasAsyncFunc() {
        }

        @SuppressFBWarnings(value={"TBP_TRISTATE_BOOLEAN_PATTERN", "ITC_INHERITANCE_TYPE_CHECKING"})
        public Boolean apply(Object input) {
            Program prog;
            if (input instanceof Program ? (prog = (Program)input).getExecType() == Program.ExecutionType.ASYNC : input instanceof CALLA) {
                return Boolean.TRUE;
            }
            return null;
        }
    }

    private static final class HasDeterministicFunc
    implements Function<Object, Boolean> {
        private HasDeterministicFunc() {
        }

        @SuppressFBWarnings(value={"TBP_TRISTATE_BOOLEAN_PATTERN"})
        public Boolean apply(Object input) {
            Program prog;
            if (input instanceof Program && ((prog = (Program)input).getType() == Program.Type.DETERMINISTIC || prog.hasDeterministicFunctions())) {
                return Boolean.TRUE;
            }
            return null;
        }
    }
}

