/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.spf4j.base.Pair;

public final class MemoryBuilder {
    private final ArrayList<Object> memory;
    private final Map<String, Integer> symbolTable;
    private int idx = 0;

    public MemoryBuilder() {
        this.memory = new ArrayList();
        this.symbolTable = new HashMap<String, Integer>();
    }

    MemoryBuilder(ArrayList<Object> memory, Map<String, Integer> symbolTable) {
        this.memory = memory;
        this.symbolTable = symbolTable;
        this.idx = memory.size();
    }

    public void addSymbol(String symbol) {
        if (!this.symbolTable.containsKey(symbol)) {
            this.memory.add(null);
            this.symbolTable.put(symbol, this.idx++);
        }
    }

    public void addSymbol(String symbol, Object value) {
        if (!this.symbolTable.containsKey(symbol)) {
            this.memory.add(value);
            this.symbolTable.put(symbol, this.idx++);
        } else {
            int position = this.symbolTable.get(symbol);
            this.memory.ensureCapacity(position + 1);
            this.memory.set(position, value);
        }
    }

    public Pair<Object[], Map<String, Integer>> build() {
        return Pair.of((Object)this.memory.toArray(), new HashMap<String, Integer>(this.symbolTable));
    }

    public MemoryBuilder copy() {
        return new MemoryBuilder(new ArrayList<Object>(this.memory), new HashMap<String, Integer>(this.symbolTable));
    }

    public String toString() {
        return "MemoryBuilder{memory=" + this.memory + ", symbolTable=" + this.symbolTable + ", idx=" + this.idx + '}';
    }
}

