/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.instr;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.spf4j.base.Arrays;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.vm.ExecutionContext;
import org.spf4j.zel.vm.JavaMethodCall;
import org.spf4j.zel.vm.SuspendedException;

public final class DEREF
extends Instruction {
    private static final long serialVersionUID = 1L;
    public static final Instruction INSTANCE = new DEREF();

    private DEREF() {
    }

    @Override
    public int execute(ExecutionContext context) throws ExecutionException, SuspendedException {
        Object[] vals = context.tuple();
        context.popSyncStackVals(vals);
        DEREF.pushDeref(vals[0], vals[1], context);
        return 1;
    }

    static void pushDeref(Object relativeTo, Object ref, ExecutionContext context) {
        if (relativeTo instanceof Map) {
            context.push(((Map)relativeTo).get(ref));
        } else if (relativeTo instanceof Object[]) {
            if ("length".equals(ref)) {
                context.push(((Object[])relativeTo).length);
            } else {
                context.push(((Object[])relativeTo)[((Number)ref).intValue()]);
            }
        } else if (relativeTo instanceof int[]) {
            context.push(((int[])relativeTo)[((Number)ref).intValue()]);
        } else if (relativeTo instanceof byte[]) {
            context.push(((byte[])relativeTo)[((Number)ref).intValue()]);
        } else if (relativeTo instanceof char[]) {
            context.push(Character.valueOf(((char[])relativeTo)[((Number)ref).intValue()]));
        } else if (relativeTo instanceof long[]) {
            context.push(((long[])relativeTo)[((Number)ref).intValue()]);
        } else if (relativeTo instanceof short[]) {
            context.push(((short[])relativeTo)[((Number)ref).intValue()]);
        } else if (relativeTo instanceof List) {
            context.push(((List)relativeTo).get(((Number)ref).intValue()));
        } else {
            context.push(new JavaMethodCall(relativeTo, (String)ref));
        }
    }

    @Override
    public Object[] getParameters() {
        return Arrays.EMPTY_OBJ_ARRAY;
    }
}

