/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import com.google.common.base.Throwables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.base.Either;
import org.spf4j.concurrent.FutureBean;
import org.spf4j.zel.vm.ExecAbortException;
import org.spf4j.zel.vm.VMFuture;

@ThreadSafe
@SuppressFBWarnings(value={"NOS_NON_OWNED_SYNCHRONIZATION"})
public class VMSyncFuture<T>
implements VMFuture<T> {
    private volatile Either<T, ? extends ExecutionException> resultStore;

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final boolean isCancelled() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final boolean isDone() {
        return this.resultStore != null;
    }

    @Override
    public final Either<T, ? extends ExecutionException> getResultStore() {
        return this.resultStore;
    }

    @Override
    @SuppressFBWarnings(value={"BED_BOGUS_EXCEPTION_DECLARATION", "MDM_WAIT_WITHOUT_TIMEOUT"})
    public final synchronized T get() throws InterruptedException, ExecutionException {
        while (this.resultStore == null) {
            this.wait();
        }
        return (T)FutureBean.processResult(this.resultStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutMillis;
        long toWait = timeoutMillis = unit.toMillis(timeout);
        long startTime = System.currentTimeMillis();
        VMSyncFuture vMSyncFuture = this;
        synchronized (vMSyncFuture) {
            while (toWait > 0L && this.resultStore == null) {
                this.wait(toWait);
                toWait = timeoutMillis - (System.currentTimeMillis() - startTime);
            }
            if (this.resultStore == null) {
                throw new TimeoutException();
            }
            return (T)FutureBean.processResult(this.resultStore);
        }
    }

    @Override
    public final synchronized void setResult(T result) {
        if (this.resultStore != null) {
            throw new IllegalStateException("cannot set " + result + " result multiple times");
        }
        this.resultStore = Either.left(result);
        this.notifyAll();
    }

    @Override
    public final synchronized void setExceptionResult(ExecutionException result) {
        if (Throwables.getRootCause((Throwable)result) == ExecAbortException.INSTANCE) {
            return;
        }
        if (this.resultStore != null) {
            throw new IllegalStateException("cannot set result " + result + " multiple times");
        }
        this.resultStore = Either.right((Object)result);
        this.notifyAll();
    }

    public final String toString() {
        return "VMSyncFuture{resultStore=" + this.resultStore + '}';
    }
}

