/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.operators;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.spf4j.zel.operators.AbstractOps;
import org.spf4j.zel.operators.Operator;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
public final class BigDecimalOperators {
    private BigDecimalOperators() {
    }

    public static final class Pow
    extends AbstractOps<BigDecimal> {
        public Pow() {
            Operator<BigDecimal, Number, Number> isbc = new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.pow(b.intValue(), (MathContext)MATH_CONTEXT.get());
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
        }
    }

    public static final class Mod
    extends AbstractOps<BigDecimal> {
        public Mod() {
            Operator<BigDecimal, Number, Number> isbc = new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.toBigInteger().mod(BigInteger.valueOf(b.intValue()));
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.toBigInteger().mod(BigInteger.valueOf(b.longValue()));
                }
            });
            Operator<BigDecimal, Number, Number> dfOp = new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.toBigInteger().mod(BigDecimal.valueOf(b.doubleValue()).toBigInteger());
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.toBigInteger().mod((BigInteger)b);
                }
            });
            this.operations.put(BigDecimal.class, new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.toBigInteger().mod(((BigDecimal)b).toBigInteger());
                }
            });
        }
    }

    public static final class Div
    extends AbstractOps<BigDecimal> {
        public Div() {
            Operator<BigDecimal, Number, Number> isbc = new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.divide(new BigDecimal(b.intValue()), (MathContext)MATH_CONTEXT.get());
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.divide(new BigDecimal(b.longValue()), (MathContext)MATH_CONTEXT.get());
                }
            });
            Operator<BigDecimal, Number, Number> dfOp = new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.divide(BigDecimal.valueOf(b.doubleValue()), (MathContext)MATH_CONTEXT.get());
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.divide(new BigDecimal((BigInteger)b), (MathContext)MATH_CONTEXT.get());
                }
            });
            this.operations.put(BigDecimal.class, new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.divide((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
                }
            });
        }
    }

    public static final class Mul
    extends AbstractOps<BigDecimal> {
        public Mul() {
            Operator<BigDecimal, Number, Number> isbc = new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.multiply(new BigDecimal(b.intValue()), (MathContext)MATH_CONTEXT.get());
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.multiply(new BigDecimal(b.longValue()), (MathContext)MATH_CONTEXT.get());
                }
            });
            Operator<BigDecimal, Number, Number> dfOp = new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.multiply(BigDecimal.valueOf(b.doubleValue()), (MathContext)MATH_CONTEXT.get());
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.multiply(new BigDecimal((BigInteger)b), (MathContext)MATH_CONTEXT.get());
                }
            });
            this.operations.put(BigDecimal.class, new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.multiply((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
                }
            });
        }
    }

    public static final class Sub
    extends AbstractOps<BigDecimal> {
        public Sub() {
            Operator<BigDecimal, Number, Number> isbc = new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.subtract(new BigDecimal(b.intValue()), (MathContext)MATH_CONTEXT.get());
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.subtract(new BigDecimal(b.longValue()), (MathContext)MATH_CONTEXT.get());
                }
            });
            Operator<BigDecimal, Number, Number> dfOp = new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.subtract(BigDecimal.valueOf(b.doubleValue()), (MathContext)MATH_CONTEXT.get());
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.subtract(new BigDecimal((BigInteger)b), (MathContext)MATH_CONTEXT.get());
                }
            });
            this.operations.put(BigDecimal.class, new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.subtract((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
                }
            });
        }
    }

    public static final class Add
    extends AbstractOps<BigDecimal> {
        public Add() {
            Operator<BigDecimal, Number, Number> isbc = new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.add(new BigDecimal(b.intValue()), (MathContext)MATH_CONTEXT.get());
                }
            };
            this.operations.put(Integer.class, isbc);
            this.operations.put(Byte.class, isbc);
            this.operations.put(Character.class, isbc);
            this.operations.put(Short.class, isbc);
            this.operations.put(Long.class, new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.add(new BigDecimal(b.longValue()), (MathContext)MATH_CONTEXT.get());
                }
            });
            Operator<BigDecimal, Number, Number> dfOp = new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.add(BigDecimal.valueOf(b.doubleValue()), (MathContext)MATH_CONTEXT.get());
                }
            };
            this.operations.put(Double.class, dfOp);
            this.operations.put(Float.class, dfOp);
            this.operations.put(BigInteger.class, new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.add(new BigDecimal((BigInteger)b), (MathContext)MATH_CONTEXT.get());
                }
            });
            this.operations.put(BigDecimal.class, new Operator<BigDecimal, Number, Number>(){

                @Override
                public Number op(BigDecimal a, Number b) {
                    return a.add((BigDecimal)b, (MathContext)MATH_CONTEXT.get());
                }
            });
        }
    }
}

