/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.spf4j.base.Pair;
import org.spf4j.base.Runtime;
import org.spf4j.base.Throwables;
import org.spf4j.base.TimeSource;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.instr.LValRef;
import org.spf4j.zel.instr.var.ARRAY;
import org.spf4j.zel.instr.var.DECODE;
import org.spf4j.zel.instr.var.INT;
import org.spf4j.zel.instr.var.LOG;
import org.spf4j.zel.instr.var.MAX;
import org.spf4j.zel.instr.var.MIN;
import org.spf4j.zel.instr.var.OUT;
import org.spf4j.zel.instr.var.RANDOM;
import org.spf4j.zel.instr.var.SQRT;
import org.spf4j.zel.vm.Channel;
import org.spf4j.zel.vm.CompileContext;
import org.spf4j.zel.vm.CompileException;
import org.spf4j.zel.vm.ExecutionContext;
import org.spf4j.zel.vm.MemoryBuilder;
import org.spf4j.zel.vm.ParsingContext;
import org.spf4j.zel.vm.ProcessIO;
import org.spf4j.zel.vm.ProcessIOStreams;
import org.spf4j.zel.vm.ProgramBuilder;
import org.spf4j.zel.vm.RefOptimizer;
import org.spf4j.zel.vm.ResultCache;
import org.spf4j.zel.vm.SimpleResultCache;
import org.spf4j.zel.vm.SuspendedException;
import org.spf4j.zel.vm.VMExecutor;
import org.spf4j.zel.vm.ZelFrame;
import org.spf4j.zel.vm.gen.ParseException;
import org.spf4j.zel.vm.gen.TokenMgrError;
import org.spf4j.zel.vm.gen.ZCompiler;

@Immutable
public final class Program
implements Serializable {
    private static final long serialVersionUID = 748365748433474932L;
    private static final MemoryBuilder ZEL_GLOBAL_FUNC;
    private static volatile boolean terminated;
    private final Type type;
    private final ExecutionType execType;
    private final int id;
    private final Instruction[] instructions;
    private final ParsingContext.Location[] debug;
    private final String source;
    private final boolean hasDeterministicFunctions;
    private final Object[] globalMem;
    private final int localMemSize;
    private final Map<String, Integer> localSymbolTable;
    private final Map<String, Integer> globalSymbolTable;
    private final String name;

    Program(String name, Map<String, Integer> globalTable, Object[] globalMem, Map<String, Integer> localTable, @Nonnull Instruction[] objs, ParsingContext.Location[] debug, String source, @Nonnegative int start, @Nonnegative int end, Type progType, ExecutionType execType, boolean hasDeterministicFunctions, String ... parameterNames) throws CompileException {
        this.globalMem = globalMem;
        int length = end - start;
        this.instructions = new Instruction[length];
        System.arraycopy(objs, start, this.instructions, 0, length);
        this.type = progType;
        this.id = ProgramBuilder.generateID();
        this.execType = execType;
        this.hasDeterministicFunctions = hasDeterministicFunctions;
        this.localSymbolTable = Program.buildLocalSymTable(objs, parameterNames, length, globalTable, localTable);
        this.localMemSize = this.localSymbolTable.size();
        this.globalSymbolTable = globalTable;
        this.debug = debug;
        this.source = source;
        this.name = name;
    }

    Program(String name, Map<String, Integer> globalTable, Object[] globalMem, Map<String, Integer> localTable, @Nonnull Instruction[] instructions, ParsingContext.Location[] debug, String source, Type progType, ExecutionType execType, boolean hasDeterministicFunctions) {
        this.globalMem = globalMem;
        this.instructions = instructions;
        this.type = progType;
        this.id = ProgramBuilder.generateID();
        this.execType = execType;
        this.hasDeterministicFunctions = hasDeterministicFunctions;
        this.localSymbolTable = localTable;
        this.localMemSize = this.localSymbolTable.size();
        this.globalSymbolTable = globalTable;
        this.debug = debug;
        this.source = source;
        this.name = name;
    }

    ParsingContext.Location[] getDebug() {
        return this.debug;
    }

    public String getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    private static Map<String, Integer> buildLocalSymTable(Instruction[] instructions, String[] parameterNames1, int length, Map<String, Integer> globalTable, Map<String, Integer> addTo) throws CompileException {
        int addToSize = addTo.size();
        HashMap<String, Integer> symbolTable = new HashMap<String, Integer>(addToSize + parameterNames1.length);
        symbolTable.putAll(addTo);
        int i = addToSize;
        for (String param : parameterNames1) {
            Integer existing;
            if ((existing = symbolTable.put(param, i++)) == null) continue;
            throw new CompileException("Duplicate parameter defined: " + param);
        }
        for (int j = 0; j < length; ++j) {
            String ref;
            Integer idxr;
            Instruction code = instructions[j];
            if (!(code instanceof LValRef) || (idxr = (Integer)symbolTable.get(ref = ((LValRef)((Object)code)).getSymbol())) != null || (idxr = globalTable.get(ref)) != null) continue;
            idxr = i++;
            symbolTable.put(ref, idxr);
        }
        return symbolTable;
    }

    public Map<String, Integer> getGlobalSymbolTable() {
        return this.globalSymbolTable;
    }

    public Map<String, Integer> getLocalSymbolTable() {
        return this.localSymbolTable;
    }

    public int getLocalMemSize() {
        return this.localMemSize;
    }

    Object[] getGlobalMem() {
        return this.globalMem;
    }

    @CheckReturnValue
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Program other = (Program)obj;
        return this.id == other.id;
    }

    @CheckReturnValue
    public int hashCode() {
        return this.id;
    }

    public boolean hasDeterministicFunctions() {
        return this.hasDeterministicFunctions;
    }

    @CheckReturnValue
    public Instruction get(int i) {
        return this.instructions[i];
    }

    @CheckReturnValue
    Object[] toArray() {
        return (Object[])this.instructions.clone();
    }

    @CheckReturnValue
    public Instruction[] getCode() {
        return Arrays.copyOf(this.instructions, this.instructions.length - 1);
    }

    @CheckReturnValue
    public ParsingContext.Location[] getDebugInfo() {
        return Arrays.copyOf(this.debug, this.debug.length - 1);
    }

    @CheckReturnValue
    public int size() {
        return this.instructions.length;
    }

    public ExecutionType getExecType() {
        return this.execType;
    }

    @Nonnull
    public static Program compile(@Nonnull String zExpr, String ... varNames) throws CompileException {
        CompileContext cc = new CompileContext(ZEL_GLOBAL_FUNC.copy());
        String srcId = ZelFrame.newSource(zExpr);
        try {
            ZCompiler.compile(srcId, zExpr, cc);
        }
        catch (ParseException | TokenMgrError err) {
            throw new CompileException(err);
        }
        Program result = RefOptimizer.INSTANCE.apply(cc.getProgramBuilder().toProgram("anon@root", srcId, varNames));
        ZelFrame.annotate(srcId, result);
        return result;
    }

    static Program compile(@Nonnull String zExpr, Map<String, Integer> localTable, Object[] globalMem, Map<String, Integer> globalTable, String ... varNames) throws CompileException {
        CompileContext cc = new CompileContext(new MemoryBuilder(new ArrayList<Object>(Arrays.asList(globalMem)), globalTable));
        String srcId = ZelFrame.newSource(zExpr);
        try {
            ZCompiler.compile(srcId, zExpr, cc);
        }
        catch (ParseException | TokenMgrError err) {
            throw new CompileException(err);
        }
        Program result = cc.getProgramBuilder().toProgram("anon@root", srcId, varNames, localTable);
        ZelFrame.annotate(srcId, result);
        return result;
    }

    public Object execute() throws ExecutionException, InterruptedException {
        return this.execute(ProcessIOStreams.DEFAULT, new Object[0]);
    }

    public Object execute(Object ... args) throws ExecutionException, InterruptedException {
        return this.execute(ProcessIOStreams.DEFAULT, args);
    }

    public Object execute(@Nonnull ExecutorService execService, Object ... args) throws ExecutionException, InterruptedException {
        return this.execute(new VMExecutor(execService), ProcessIOStreams.DEFAULT, args);
    }

    public Object executeSingleThreaded(Object ... args) throws ExecutionException, InterruptedException {
        return this.execute(null, ProcessIOStreams.DEFAULT, args);
    }

    public Object execute(@Nullable VMExecutor execService, @Nullable ProcessIO io, Object ... args) throws ExecutionException, InterruptedException {
        Object[] localMem = this.allocMem(args);
        ExecutionContext ectx = new ExecutionContext(this, this.globalMem, localMem, io, execService);
        return Program.execute(ectx);
    }

    Object[] allocMem(Object[] args) {
        Object[] localMem;
        int lms = this.getLocalMemSize();
        if (args.length == lms) {
            localMem = args;
        } else {
            localMem = new Object[lms];
            System.arraycopy(args, 0, localMem, 0, args.length);
        }
        return localMem;
    }

    public Pair<Object, ExecutionContext> execute(@Nullable VMExecutor execService, @Nullable ProcessIO io, ResultCache resultCache, Object ... args) throws ExecutionException, InterruptedException {
        Object[] localMem = this.allocMem(args);
        ExecutionContext ectx = new ExecutionContext(this, this.globalMem, localMem, resultCache, io, execService);
        return Pair.of((Object)Program.execute(ectx), (Object)ectx);
    }

    public static Object executeSync(@Nonnull ExecutionContext ectx) throws ExecutionException, InterruptedException {
        try {
            return ectx.call();
        }
        catch (SuspendedException ex) {
            throw new ExecutionException("Suspension not supported in sync calls " + ectx, ex);
        }
    }

    public static Object execute(@Nonnull ExecutionContext ectx) throws ExecutionException, InterruptedException {
        Object result = ectx.executeSyncOrAsync();
        if (result instanceof Future) {
            return ((Future)result).get();
        }
        return result;
    }

    public Object execute(ProcessIO io, Object ... args) throws ExecutionException, InterruptedException {
        if (this.execType == ExecutionType.SYNC) {
            return this.execute((VMExecutor)null, io, args);
        }
        return this.execute(VMExecutor.Lazy.DEFAULT, io, args);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        String line;
        System.out.println("ZEL Shell");
        Map<String, Integer> localSymTable = Collections.emptyMap();
        Pair<Object[], Map<String, Integer>> gmemPair = ZEL_GLOBAL_FUNC.build();
        Map<String, Integer> globalSymTable = (Map<String, Integer>)gmemPair.getSecond();
        Object[] mem = new Object[]{};
        Object[] gmem = (Object[])gmemPair.getFirst();
        ResultCache resCache = new SimpleResultCache();
        InputStreamReader inp = new InputStreamReader(System.in, StandardCharsets.UTF_8);
        BufferedReader br = new BufferedReader(inp);
        Runtime.queueHookAtBeginning((Runnable)new Runnable(){

            @Override
            public void run() {
                terminated = true;
                try {
                    System.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        System.out.println("zel>\n");
        while (!terminated && (line = br.readLine()) != null) {
            if ("QUIT".equalsIgnoreCase(line = line.trim())) {
                terminated = true;
                continue;
            }
            try {
                Program prog = Program.compile(line, localSymTable, gmem, globalSymTable, new String[0]);
                localSymTable = prog.getLocalSymbolTable();
                globalSymTable = prog.getGlobalSymbolTable();
                gmem = prog.getGlobalMem();
                long startTime = TimeSource.nanoTime();
                Pair<Object, ExecutionContext> res = prog.execute(VMExecutor.Lazy.DEFAULT, ProcessIOStreams.DEFAULT, resCache, mem);
                long elapsed = TimeSource.nanoTime() - startTime;
                Object result = res.getFirst();
                System.out.println("result> " + result);
                System.out.println("type> " + (result == null ? "none" : result.getClass()));
                System.out.println("executed in> " + elapsed + " ns");
                ExecutionContext execCtx = (ExecutionContext)res.getSecond();
                mem = execCtx.getMem();
                resCache = execCtx.getResultCache();
            }
            catch (CompileException ex) {
                System.err.println("Syntax Error:\n");
                Throwables.writeTo((Throwable)ex, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT);
            }
            catch (ExecutionException ex) {
                System.err.println("Execution Error:\n");
                Throwables.writeTo((Throwable)ex, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT);
            }
            System.out.println("zel>");
        }
    }

    public String toAssemblyString() {
        StringBuilder result = new StringBuilder();
        result.append("Program: \n");
        for (int i = 0; i < this.instructions.length; ++i) {
            Instruction obj = this.instructions[i];
            result.append(Strings.padEnd((String)Integer.toString(i), (int)8, (char)' '));
            result.append(':');
            result.append(obj);
            result.append('\n');
        }
        result.append("execType = ").append((Object)this.execType).append('\n');
        result.append("type = ").append((Object)this.type).append('\n');
        return result.toString();
    }

    public String toString() {
        return this.source;
    }

    public Type getType() {
        return this.type;
    }

    public boolean contains(Class<? extends Instruction> instr) {
        Boolean res = this.itterate(new HasClass(instr));
        if (res == null) {
            return false;
        }
        return res;
    }

    @Nullable
    public <T> T itterate(Function<Object, T> func) {
        for (Instruction code : this.instructions) {
            T res = func.apply(code);
            if (res != null) {
                return res;
            }
            for (Object param : code.getParameters()) {
                res = func.apply(param);
                if (res != null) {
                    return res;
                }
                if (param instanceof Program) {
                    res = ((Program)param).itterate(func);
                }
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    Instruction[] getInstructions() {
        return this.instructions;
    }

    static {
        terminated = false;
        ZEL_GLOBAL_FUNC = new MemoryBuilder();
        ZEL_GLOBAL_FUNC.addSymbol("out", OUT.INSTANCE);
        ZEL_GLOBAL_FUNC.addSymbol("sqrt", SQRT.INSTANCE);
        ZEL_GLOBAL_FUNC.addSymbol("int", INT.INSTANCE);
        ZEL_GLOBAL_FUNC.addSymbol("log", LOG.INSTANCE);
        ZEL_GLOBAL_FUNC.addSymbol("log10", LOG.INSTANCE);
        ZEL_GLOBAL_FUNC.addSymbol("min", MIN.INSTANCE);
        ZEL_GLOBAL_FUNC.addSymbol("max", MAX.INSTANCE);
        ZEL_GLOBAL_FUNC.addSymbol("array", ARRAY.INSTANCE);
        ZEL_GLOBAL_FUNC.addSymbol("random", RANDOM.INSTANCE);
        ZEL_GLOBAL_FUNC.addSymbol("channel", Channel.Factory.INSTANCE);
        ZEL_GLOBAL_FUNC.addSymbol("EOF", Channel.EOF);
        ZEL_GLOBAL_FUNC.addSymbol("decode", DECODE.INSTANCE);
    }

    public static final class HasClass
    implements Function<Object, Boolean> {
        private final Class<? extends Instruction> instr;

        public HasClass(Class<? extends Instruction> instr) {
            this.instr = instr;
        }

        @Override
        @Nullable
        @SuppressFBWarnings(value={"TBP_TRISTATE_BOOLEAN_PATTERN", "NP_BOOLEAN_RETURN_NULL"})
        public Boolean apply(@Nonnull Object input) {
            if (input.getClass() == this.instr) {
                return Boolean.TRUE;
            }
            return null;
        }
    }

    public static enum ExecutionType {
        SYNC,
        ASYNC;

    }

    public static enum Type {
        DETERMINISTIC,
        NONDETERMINISTIC;

    }
}

