/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.spf4j.base.CharSequences;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.vm.ParsingContext;
import org.spf4j.zel.vm.Program;

@SuppressFBWarnings(value={"FCCD_FIND_CLASS_CIRCULAR_DEPENDENCY"})
public final class ZelFrame
implements Serializable {
    private static final ConcurrentMap<String, CharSequence> SOURCES = new ConcurrentHashMap<String, CharSequence>();
    private static final AtomicInteger IDX = new AtomicInteger();
    private static final long serialVersionUID = 1L;
    private final String programName;
    private final String source;
    private final int index;

    public static String newSource(CharSequence sourceDetail) {
        String id = "zel_" + IDX.getAndIncrement();
        SOURCES.put(id, CharSequences.toLineNumbered((int)0, (CharSequence)sourceDetail));
        return id;
    }

    public static void annotate(String id, Program program) {
        CharSequence source = (CharSequence)SOURCES.get(id);
        String[] lines = source.toString().split("\n");
        StringBuilder[] annotations = new StringBuilder[lines.length];
        Instruction[] instructions = program.getInstructions();
        ParsingContext.Location[] debug = program.getDebug();
        for (int i = 0; i < instructions.length; ++i) {
            ParsingContext.Location loc = debug[i];
            int lineNr = loc.getRow();
            if (lineNr < 0) continue;
            StringBuilder existing = annotations[lineNr];
            if (existing == null) {
                existing = new StringBuilder();
                existing.append(" /* ").append(instructions[i]);
                annotations[lineNr] = existing;
                continue;
            }
            existing.append(';').append(instructions[i]);
        }
        StringBuilder result = new StringBuilder(source.length() * 2);
        for (int i = 0; i < lines.length; ++i) {
            result.append(lines[i]);
            StringBuilder annotation = annotations[i];
            if (annotation != null) {
                result.append((CharSequence)annotation).append(" */\n");
                continue;
            }
            result.append('\n');
        }
        SOURCES.put(id, result);
    }

    public static CharSequence getDetail(String id) {
        return (CharSequence)SOURCES.get(id);
    }

    public ZelFrame(String programName, String source, int index) {
        this.programName = programName;
        this.index = index;
        this.source = source;
    }

    public String toString() {
        return this.programName + '(' + this.source + ':' + this.index + ')';
    }

    public String getProgramName() {
        return this.programName;
    }

    public String getSource() {
        return this.source;
    }

    public int getIndex() {
        return this.index;
    }
}

