/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.instr;

import java.math.MathContext;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.operators.Operator;
import org.spf4j.zel.vm.ExecutionContext;

public final class MCTX
extends Instruction {
    private static final long serialVersionUID = 1L;
    private final int precission;

    public MCTX(int precission) {
        this.precission = precission;
    }

    @Override
    public int execute(ExecutionContext context) {
        MathContext mc;
        switch (this.precission) {
            case 32: {
                mc = MathContext.DECIMAL32;
                break;
            }
            case 64: {
                mc = MathContext.DECIMAL64;
                break;
            }
            case 128: {
                mc = MathContext.DECIMAL128;
                break;
            }
            default: {
                mc = new MathContext(this.precission);
            }
        }
        context.setMathContext(mc);
        Operator.MATH_CONTEXT.set(mc);
        return 1;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.precission};
    }
}

