/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.instr;

import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.instr.RValRef;
import org.spf4j.zel.vm.ExecutionContext;
import org.spf4j.zel.vm.Program;
import org.spf4j.zel.vm.ZExecutionException;

public final class LODX
extends Instruction
implements RValRef {
    private static final long serialVersionUID = 1L;
    private final String symbol;

    public LODX(String symbol) {
        this.symbol = symbol;
    }

    public static Object readFrom(String symbol, ExecutionContext context) throws ZExecutionException {
        Program code = context.getProgram();
        Integer addr = code.getLocalSymbolTable().get(symbol);
        if (addr == null) {
            addr = code.getGlobalSymbolTable().get(symbol);
            if (addr == null) {
                throw new ZExecutionException("unalocated symbol encountered " + symbol);
            }
            return context.globalPeek(addr);
        }
        return context.localPeek(addr);
    }

    @Override
    public int execute(ExecutionContext context) throws ZExecutionException {
        context.push(LODX.readFrom(this.symbol, context));
        return 1;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.symbol};
    }
}

