/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.instr;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.avro.generic.GenericRecord;
import org.spf4j.base.Arrays;
import org.spf4j.reflect.CachingTypeMapWrapper;
import org.spf4j.reflect.GraphTypeMap;
import org.spf4j.reflect.TypeMap;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.vm.ExecutionContext;
import org.spf4j.zel.vm.SuspendedException;

public final class DEREF
extends Instruction {
    private static final long serialVersionUID = 1L;
    public static final Instruction INSTANCE = new DEREF();
    private static final CachingTypeMapWrapper<ReferenceHandler> TYPE_HANDLER = new CachingTypeMapWrapper((TypeMap)new GraphTypeMap());

    private DEREF() {
    }

    public static void registerTypeDerefHandler(Type type, ReferenceHandler refHandler) {
        TYPE_HANDLER.safePut(type, (Object)refHandler);
    }

    public static synchronized void replaceTypeDerefHandler(Type type, ReferenceHandler refHandler) {
        TYPE_HANDLER.replace(type, x -> refHandler);
    }

    @Override
    public int execute(ExecutionContext context) throws ExecutionException, SuspendedException {
        Object[] vals = context.tuple();
        context.popSyncStackVals(vals);
        DEREF.pushDeref(vals[0], vals[1], context);
        return 1;
    }

    static void pushDeref(Object relativeTo, Object ref, ExecutionContext context) {
        ReferenceHandler rh = (ReferenceHandler)TYPE_HANDLER.get(relativeTo.getClass());
        rh.pushDeref(relativeTo, ref, context);
    }

    @Override
    public Object[] getParameters() {
        return Arrays.EMPTY_OBJ_ARRAY;
    }

    static {
        TYPE_HANDLER.safePut(Map.class, (relativeTo, ref, context) -> context.push(((Map)relativeTo).get(ref))).safePut(GenericRecord.class, (relativeTo, ref, context) -> context.push(((GenericRecord)relativeTo).get(ref.toString()))).safePut(Object.class, (relativeTo, ref, context) -> context.push(context.newJavaCall(relativeTo, (String)ref))).safePut(Object[].class, (relativeTo, ref, context) -> {
            if ("length".equals(ref)) {
                context.push(((Object[])relativeTo).length);
            } else {
                context.push(((Object[])relativeTo)[((Number)ref).intValue()]);
            }
        }).safePut(int[].class, (relativeTo, ref, context) -> {
            if ("length".equals(ref)) {
                context.push(((int[])relativeTo).length);
            } else {
                context.push(((int[])relativeTo)[((Number)ref).intValue()]);
            }
        }).safePut(byte[].class, (relativeTo, ref, context) -> {
            if ("length".equals(ref)) {
                context.push(((byte[])relativeTo).length);
            } else {
                context.push(((byte[])relativeTo)[((Number)ref).intValue()]);
            }
        }).safePut(char[].class, (relativeTo, ref, context) -> {
            if ("length".equals(ref)) {
                context.push(((char[])relativeTo).length);
            } else {
                context.push(Character.valueOf(((char[])relativeTo)[((Number)ref).intValue()]));
            }
        }).safePut(long[].class, (relativeTo, ref, context) -> {
            if ("length".equals(ref)) {
                context.push(((long[])relativeTo).length);
            } else {
                context.push(((long[])relativeTo)[((Number)ref).intValue()]);
            }
        }).safePut(short[].class, (relativeTo, ref, context) -> {
            if ("length".equals(ref)) {
                context.push(((short[])relativeTo).length);
            } else {
                context.push(((short[])relativeTo)[((Number)ref).intValue()]);
            }
        }).safePut(List.class, (relativeTo, ref, context) -> {
            if ("length".equals(ref)) {
                context.push(((List)relativeTo).size());
            } else {
                context.push(((List)relativeTo).get(((Number)ref).intValue()));
            }
        });
    }

    static interface ReferenceHandler {
        public void pushDeref(Object var1, Object var2, ExecutionContext var3);
    }
}

