/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.instr;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.spf4j.base.Arrays;
import org.spf4j.base.Pair;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.vm.ExecutionContext;
import org.spf4j.zel.vm.SuspendedException;
import org.spf4j.zel.vm.VMASyncFuture;
import org.spf4j.zel.vm.VMExecutor;
import org.spf4j.zel.vm.VMFuture;

@SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
public final class SLEEP
extends Instruction {
    private static final long serialVersionUID = 1L;
    public static final Instruction INSTANCE = new SLEEP();

    private SLEEP() {
    }

    @Override
    public int execute(ExecutionContext context) throws SuspendedException, InterruptedException, ExecutionException {
        Number param = (Number)context.popSyncStackVal();
        long sleepMillis = param.longValue();
        if (sleepMillis > 0L) {
            if (context.getExecService() == null) {
                Thread.sleep(sleepMillis);
            } else {
                VMASyncFuture<Object> future = new VMASyncFuture<Object>();
                DefaultScheduler.INSTANCE.schedule(new RunnableImpl(context, future), sleepMillis, TimeUnit.MILLISECONDS);
                context.incrementInstructionPointer();
                context.suspend(future);
            }
        }
        return 1;
    }

    @Override
    public Object[] getParameters() {
        return Arrays.EMPTY_OBJ_ARRAY;
    }

    private static final class RunnableImpl
    implements Runnable {
        private final ExecutionContext context;
        private final VMASyncFuture<Object> future;

        RunnableImpl(ExecutionContext context, VMASyncFuture<Object> future) {
            this.context = context;
            this.future = future;
        }

        @Override
        public void run() {
            List<Pair<VMExecutor.Suspendable<Object>, VMFuture<Object>>> stuff;
            while ((stuff = this.context.getExecService().resumeSuspendables(this.future)) == null) {
            }
        }
    }
}

