/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.zel.vm;

import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.Either;
import org.spf4j.base.Throwables;
import org.spf4j.ds.SimpleStackNullSupport;
import org.spf4j.zel.instr.Instruction;
import org.spf4j.zel.operators.Operator;
import org.spf4j.zel.vm.JavaMethodCall;
import org.spf4j.zel.vm.ProcessIO;
import org.spf4j.zel.vm.Program;
import org.spf4j.zel.vm.ResultCache;
import org.spf4j.zel.vm.SimpleResultCache;
import org.spf4j.zel.vm.SuspendedException;
import org.spf4j.zel.vm.VMExecutor;
import org.spf4j.zel.vm.VMFuture;
import org.spf4j.zel.vm.ZExecutionException;
import org.spf4j.zel.vm.ZelFrame;

@ParametersAreNonnullByDefault
public final class ExecutionContext
implements VMExecutor.Suspendable<Object> {
    public static final Object VOID = new Object(){

        public String toString() {
            return "VOID";
        }
    };
    private final Object[] tuple = new Object[2];
    @Nonnull
    private MathContext mathContext;
    private final VMExecutor execService;
    private final ResultCache resultCache;
    private final Object[] mem;
    private final Object[] globalMem;
    private final Program code;
    private int ip;
    private final SimpleStackNullSupport<Object> stack;
    private final transient ProcessIO io;
    private List<VMFuture<Object>> suspendedAt;
    private final boolean isChildContext;

    private ExecutionContext(ExecutionContext parent, @Nullable VMExecutor service, Program program, Object[] localMem) {
        this(program, parent.globalMem, localMem, parent.resultCache, parent.io, service, true);
    }

    ExecutionContext(Program program, Object[] globalMem, @Nullable ProcessIO io, @Nullable VMExecutor execService) {
        this(program, globalMem, new Object[program.getLocalMemSize()], program.hasDeterministicFunctions() ? new SimpleResultCache() : null, io, execService);
    }

    public ExecutionContext(Program program, Object[] globalMem, Object[] localMem, @Nullable ProcessIO io, @Nullable VMExecutor execService) {
        this(program, globalMem, localMem, program.hasDeterministicFunctions() ? new SimpleResultCache() : null, io, execService);
    }

    ExecutionContext(Program program, Object[] globalMem, Object[] localMem, @Nullable ResultCache resultCache, @Nullable ProcessIO io, @Nullable VMExecutor execService) {
        this(program, globalMem, localMem, resultCache, io, execService, false);
    }

    ExecutionContext(Program program, Object[] globalMem, Object[] localMem, @Nullable ResultCache resultCache, @Nullable ProcessIO io, @Nullable VMExecutor execService, boolean isChildContext) {
        this.code = program;
        this.io = io;
        this.execService = execService;
        this.stack = new SimpleStackNullSupport(8);
        this.ip = 0;
        this.mem = localMem;
        this.globalMem = globalMem;
        this.resultCache = resultCache;
        this.isChildContext = isChildContext;
        this.mathContext = MathContext.DECIMAL128;
    }

    public ProcessIO getIo() {
        return this.io;
    }

    public JavaMethodCall newJavaCall(Object object, String method) {
        if (object instanceof Class && !"getName".equals(method)) {
            throw new UnsupportedOperationException("Not allowed invoking methods on class: " + object);
        }
        return new JavaMethodCall(object, method);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Object[] getMem() {
        return this.mem;
    }

    public void globalPoke(int addr, Object value) {
        this.globalMem[addr] = value;
    }

    public void localPoke(int addr, Object value) {
        this.mem[addr] = value;
    }

    public Object localPeek(int addr) {
        return this.mem[addr];
    }

    public Object globalPeek(int addr) {
        return this.globalMem[addr];
    }

    public Program getProgram() {
        return this.code;
    }

    public void incrementInstructionPointer() {
        ++this.ip;
    }

    public void terminate() {
        this.ip = this.code.size();
    }

    @SuppressFBWarnings(value={"URV_UNRELATED_RETURN_VALUES"})
    public Object executeSyncOrAsync() throws ExecutionException, InterruptedException {
        if (this.execService != null && this.code.getExecType() == Program.ExecutionType.ASYNC) {
            if (this.isChildContext()) {
                return this.execService.submitInternal(VMExecutor.synchronize(this));
            }
            return this.execService.submit(VMExecutor.synchronize(this));
        }
        try {
            return this.call();
        }
        catch (SuspendedException ex) {
            throw new ExecutionException("Suspending not supported in current context: " + this, ex);
        }
    }

    @SuppressFBWarnings(value={"URV_UNRELATED_RETURN_VALUES"})
    public Object executeAsync() throws ExecutionException, InterruptedException {
        if (this.execService != null) {
            if (this.isChildContext()) {
                return this.execService.submitInternal(VMExecutor.synchronize(this));
            }
            return this.execService.submit(VMExecutor.synchronize(this));
        }
        try {
            return this.call();
        }
        catch (SuspendedException ex) {
            throw new ExecutionException("Suspending not supported for " + this, ex);
        }
    }

    public void suspend(VMFuture<Object> future) throws SuspendedException {
        this.suspendedAt = Collections.singletonList(future);
        throw SuspendedException.INSTANCE;
    }

    public void suspend(List<VMFuture<Object>> futures) throws SuspendedException {
        this.suspendedAt = futures;
        throw SuspendedException.INSTANCE;
    }

    @Override
    public Object call() throws ExecutionException, InterruptedException, SuspendedException {
        this.suspendedAt = null;
        Operator.MATH_CONTEXT.set(this.getMathContext());
        Instruction[] instructions = this.code.getInstructions();
        int l = instructions.length;
        try {
            while (this.ip < l) {
                Instruction icode = instructions[this.ip];
                this.ip += icode.execute(this);
            }
            if (!this.isStackEmpty()) {
                Object result = this.popSyncStackVal();
                this.syncStackVals();
                return result;
            }
            return VOID;
        }
        catch (InterruptedException | SuspendedException e) {
            throw e;
        }
        catch (ZExecutionException e) {
            e.addZelFrame(new ZelFrame(this.code.getName(), this.code.getSource(), this.code.getDebug()[this.ip].getRow()));
            throw e;
        }
    }

    @Override
    public List<VMFuture<Object>> getSuspendedAt() {
        return this.suspendedAt;
    }

    public Object popSyncStackVal() throws SuspendedException, ExecutionException {
        Object result = this.stack.peek();
        if (result instanceof VMFuture) {
            VMFuture resFut = (VMFuture)result;
            Either resultStore = resFut.getResultStore();
            if (resultStore != null) {
                this.stack.remove();
                return Either.processResult(resultStore);
            }
            this.suspend(resFut);
            throw new IllegalThreadStateException();
        }
        this.stack.remove();
        return result;
    }

    public Object peekSyncStackVal() throws SuspendedException, ExecutionException {
        Object result = this.stack.peek();
        if (result instanceof VMFuture) {
            VMFuture resFut = (VMFuture)result;
            Either resultStore = resFut.getResultStore();
            if (resultStore != null) {
                return Either.processResult(resultStore);
            }
            this.suspend(resFut);
            throw new IllegalThreadStateException();
        }
        return result;
    }

    public void syncStackVal() throws SuspendedException, ExecutionException {
        Object result = this.stack.peek();
        if (result instanceof VMFuture) {
            VMFuture resFut = (VMFuture)result;
            Either resultStore = resFut.getResultStore();
            if (resultStore == null) {
                this.suspend(resFut);
                throw new IllegalThreadStateException();
            }
            this.stack.replaceFromTop(0, Either.processResult(resultStore));
        }
    }

    public void syncStackVals() throws SuspendedException, ExecutionException {
        for (int i = 0; i < this.stack.size(); ++i) {
            Object result = this.stack.peekFromTop(i);
            if (!(result instanceof VMFuture)) continue;
            VMFuture resFut = (VMFuture)result;
            Either resultStore = resFut.getResultStore();
            if (resultStore == null) {
                this.suspend(resFut);
                throw new IllegalThreadStateException();
            }
            this.stack.replaceFromTop(i, Either.processResult(resultStore));
        }
    }

    public Object[] popStackVals(int nvals) {
        return this.stack.pop(nvals);
    }

    public void popStackVals(Object[] to, int nvals) {
        this.stack.popTo(to, nvals);
    }

    public Object popStackVal() {
        return this.stack.pop();
    }

    public int getNrStackVals() {
        return this.stack.size();
    }

    public Object[] popSyncStackVals(int nvals) throws SuspendedException, ExecutionException {
        if (nvals == 0) {
            return org.spf4j.base.Arrays.EMPTY_OBJ_ARRAY;
        }
        Object[] result = new Object[nvals];
        this.popSyncStackVals(result);
        return result;
    }

    @SuppressFBWarnings
    public Object[] tuple() {
        return this.tuple;
    }

    public void popSyncStackVals(Object[] vals) throws SuspendedException, ExecutionException {
        int l = vals.length;
        this.popSyncStackVals(vals, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void popSyncStackVals(Object[] vals, int l) throws ExecutionException, SuspendedException {
        int i = 0;
        int j = l - 1;
        while (true) {
            if (i >= l) {
                this.stack.removeFromTop(l);
                return;
            }
            Object obj = this.stack.peekFromTop(i);
            if (obj instanceof VMFuture) {
                VMFuture resFut = (VMFuture)obj;
                Either resultStore = resFut.getResultStore();
                if (resultStore == null) {
                    this.suspend(resFut);
                    throw new IllegalStateException();
                }
                Object processResult = Either.processResult(resultStore);
                this.stack.replaceFromTop(i, processResult);
                vals[j] = processResult;
            } else {
                vals[j] = obj;
            }
            ++i;
            --j;
        }
    }

    public Object popFirstAvail(int nr) throws SuspendedException {
        int nrErrors = 0;
        ExecutionException e = null;
        ArrayList<VMFuture> futures = null;
        for (int i = 0; i < nr; ++i) {
            Object obj = this.stack.peekFromTop(i);
            if (obj instanceof VMFuture) {
                VMFuture resFut = (VMFuture)obj;
                Either resultStore = resFut.getResultStore();
                if (resultStore != null) {
                    if (resultStore.isLeft()) {
                        this.stack.removeFromTop(nr);
                        return resultStore.getLeft();
                    }
                    ++nrErrors;
                    ExecutionException exRes = (ExecutionException)resultStore.getRight();
                    if (e != null) {
                        Throwables.suppressLimited((Throwable)exRes, (Throwable)e);
                    }
                    e = exRes;
                    continue;
                }
                if (futures == null) {
                    futures = new ArrayList<VMFuture>(nr);
                }
                futures.add(resFut);
                continue;
            }
            this.stack.removeFromTop(nr);
            return obj;
        }
        if (nrErrors == nr) {
            if (e == null) {
                throw new IllegalStateException();
            }
            throw new UncheckedExecutionException(e);
        }
        if (futures == null || futures.isEmpty()) {
            throw new IllegalStateException();
        }
        this.suspend((List<VMFuture<Object>>)futures);
        throw new IllegalStateException();
    }

    public Object pop() {
        return this.stack.pop();
    }

    public void push(@Nullable Object obj) {
        this.stack.push(obj);
    }

    public void pushNull() {
        this.stack.pushNull();
    }

    public boolean isStackEmpty() {
        return this.stack.isEmpty();
    }

    public Object peek() {
        return this.stack.peek();
    }

    public Object peekFromTop(int n) {
        return this.stack.peekFromTop(n);
    }

    public ExecutionContext getSubProgramContext(Program program, int nrParams) throws ExecutionException, SuspendedException {
        Object[] localMem = new Object[program.getLocalMemSize()];
        if (program.getExecType() == Program.ExecutionType.SYNC) {
            this.popSyncStackVals(localMem, nrParams);
            return new ExecutionContext(this, null, program, localMem);
        }
        this.popStackVals(localMem, nrParams);
        return new ExecutionContext(this, this.execService, program, localMem);
    }

    public ExecutionContext getSyncSubProgramContext(Program program, int nrParams) throws ExecutionException, SuspendedException {
        Object[] localMem = new Object[program.getLocalMemSize()];
        this.popSyncStackVals(localMem, nrParams);
        return new ExecutionContext(this, null, program, localMem);
    }

    public ExecutionContext getSyncSubProgramContext(Program program, Object[] parameters) {
        Object[] localMem = program.allocMem(parameters);
        return new ExecutionContext(this, null, program, localMem);
    }

    public String toString() {
        return "ExecutionContext{execService=" + this.getExecService() + ",\nresultCache=" + this.getResultCache() + ",\nmemory=" + Arrays.toString(this.mem) + ",\nlocalSymbolTable=" + this.code.getLocalSymbolTable() + ",\nglobalMem=" + Arrays.toString(this.globalMem) + ",\nglobalSymbolTable=" + this.code.getGlobalSymbolTable() + ",\ncode=" + this.code + ", ip=" + this.ip + ",\nstack=" + this.stack + ", io=" + this.io + '}';
    }

    public boolean isChildContext() {
        return this.isChildContext;
    }

    @Nonnull
    public MathContext getMathContext() {
        return this.mathContext;
    }

    public void setMathContext(@Nonnull MathContext mathContext) {
        this.mathContext = mathContext;
    }

    @Nullable
    public VMExecutor getExecService() {
        return this.execService;
    }

    public ResultCache getResultCache() {
        return this.resultCache;
    }
}

